package com.netcore.android.smartechbase.communication


interface SmartechInterface {

    /**
     *  This function will be used to pass the Hansel event back to Smartech SDK for processing.
     *  @param eventName Name of the event to be tracked
     *  @param eventPayLoad Event Payload with default value null.
     */
    fun trackEventFromHansel(eventName: String?, eventPayLoad: HashMap<String, Any>? = null)

    /**
     *  This function will return the GUID generated by the Smartech to Hansel
     */
    fun getUUID(): String

    /**
     *  This method should be called to fetch data for List and Segment.
     */
    fun fetchListAndSegment()
}