package com.netcore.android.smartechbase.communication

import android.app.Application


interface HanselInterface {

    /**
     * This method initializes the SDK, if not already
     *
     * @param app Instance of the Application object.
     * @param smartechInterface Object through which HanselSDK can interact with Smartech SDK
     * @param guid The id assigned to this device
     */
    fun init(app: Application, smartechInterface: SmartechInterface, deviceId: String)

    fun init(app: Application, smartechInterface: SmartechInterface, hanselAppId: String?, hanselAppKey: String?, guid: String)


    /**
     * This function captures the properties of an event. These properties can be used by Hansel for segmentation
     * The function also return some properties which the caller should add to the payload of the event
     * before sending it to the server.
     */
    fun logEvent(eventName: String, vendorName: String, properties: HashMap<String, Any>?): HashMap<String, String>?

    /**
     *  This function is used to set the list of segments this user is a part of
     *  @param lists List of segments which this user is a part of.
     */
    fun setListAndSegmentsForUser(lists: List<String>, segments: List<String>)


    /**
     * This function passes the properties of a user to HanselSDK
     */
    fun setUserAttributes(userAttributes: Map<String, Any>)

    /**
     * Function to register the identity of a user with Hansel
     */
    fun login(userIdentity: String?)

    /**
     * Function to clear all the attributes of a user
     */
    fun clearUserIdentity()

}