package com.netcore.android.preference

import com.netcore.android.utility.SMTGWSource

class SMTTokenPreferenceHelper(private val gwSource: SMTGWSource) {
    lateinit var currentPushTokenPreferenceKeyName: String
    lateinit var currentTokenPreferenceKeyName: String
    lateinit var oldPushTokenPreferenceKeyName: String
    lateinit var oldTokenPreferenceKeyName: String

    init {
        initKeyNames()
    }

    private fun initKeyNames() {
        when (gwSource.value) {
            SMTGWSource.FCM.value, SMTGWSource.PUSH_AMP.value -> {
                currentPushTokenPreferenceKeyName = SMTPreferenceConstants.PUSH_TOKEN_CURRENT
                currentTokenPreferenceKeyName = SMTPreferenceConstants.FCM_PUSH_TOKEN_CURRENT
                oldPushTokenPreferenceKeyName = SMTPreferenceConstants.PUSH_TOKEN_OLD
                oldTokenPreferenceKeyName = SMTPreferenceConstants.FCM_PUSH_TOKEN_OLD
            }
            SMTGWSource.XIAOMI.value -> {
                currentPushTokenPreferenceKeyName = SMTPreferenceConstants.XIAOMI_TOKEN_CURRENT
                currentTokenPreferenceKeyName = SMTPreferenceConstants.XIAOMI_PUSH_TOKEN_CURRENT
                oldPushTokenPreferenceKeyName = SMTPreferenceConstants.XIAOMI_TOKEN_OLD
                oldTokenPreferenceKeyName = SMTPreferenceConstants.XIAOMI_PUSH_TOKEN_OLD
            }
        }
    }
}