package com.netcore.android.notification

import android.content.Context
import com.netcore.android.notification.audio.SMTRichAudioPNGenerator
import com.netcore.android.notification.carousel.SMTCarouselLandscapePNGenerator
import com.netcore.android.notification.carousel.SMTCarouselPortraitPNGenerator
import com.netcore.android.notification.gif.SMTRichGifPNGenerator
import java.lang.ref.WeakReference

internal class SMTNotificationGeneratorProvider {
    fun getNotificationGenerator(type: String, context: Context): Any {
        return when (type) {
            SMTNotificationType.CAROUSEL_LANDSCAPE.type -> SMTCarouselLandscapePNGenerator(WeakReference(context))
            SMTNotificationType.CAROUSEL_PORTRAIT.type -> SMTCarouselPortraitPNGenerator(WeakReference(context))
            SMTNotificationType.GIF.type -> SMTRichGifPNGenerator.getInstance(WeakReference(context))
            SMTNotificationType.AUDIO.type -> SMTRichAudioPNGenerator.getInstance()
            SMTNotificationType.BIG_IMAGE.type -> SMTRichImagePNGenerator()
            else -> SMTSimplePNGenerator()
        }
    }
}