package com.netcore.android.notification

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Notification constants
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal object SMTNotificationConstants {

    //Notification Channel info
    const val NOTIF_CHANNEL_ID = "smtNotificationChannelId"
    const val NOTIF_CHANNEL_NAME = "smtNotificationChannelName"
    const val NOTIF_CHANNEL_DESCRIPTION = "smtNotificationChannelDescription"
    const val NOTIF_ACTIONS = "smartechNotificationListener"
    const val NOTIF_ACTION = "smatechAction"
    const val NOTIF_ACTION_DISMISS = "com.netcore.android.notif_action_delete"

    // PN Action Constants
    const val CAROUSEL_LEFT_ARROW_CLICKED = 1
    const val CAROUSEL_RIGHT_ARROW_CLICKED = 2
    const val CAROUSEL_LEFT_ITEM_CLICKED = 3
    const val CAROUSEL_RIGHT_ITEM_CLICKED = 4
    const val CAROUSEL_OTHER_REGION_CLICKED = 5

    const val CAROUSEL_SET_UP_KEY = "com.netcore.android.CAROUSEL_SET_UP_KEY"
    const val CAROUSEL_ITEM_CLICKED_KEY = "carouselItemClicked"

    const val GIF_OTHER_REGION_CLICKED = 6
    const val GIF_PLAY_BUTTON_CLICKED = 7
    const val GIF_ITEM_CLICKED_KEY = "gifItemClickedKey"

    const val NOTIF_STICKY_ACTION_CLOSE = 8

    //Audio notification related constants
    const val AUDIO_NOTIF_OTHER_REGION_CLICKED = "audio_other_region_clicked"
    const val AUDIO_NOTIF_CLICKED_KEY = "audio_clicked_key"
    const val NOTIFICATION_PARCEL = "notificationParcel"

    const val IMAGE_NOTIF_OTHER_REGION_CLICKED_KEY = "image_other_region_clicked"
    const val IMAGE_NOTIF_CLICKED = "image_clicked"
    const val SIMPLE_NOTIF_OTHER_REGION_CLICKED_KEY = "simple_other_region_clicked"

    // Notificaiton Values
    const val NOTIF_SOURCE_VALUE = "Smartech"

    // NOTIFICATION keys used for Parsing
    const val NOTIF_DATA_KEY = "data"
    const val NOTIF_SMT_PAYLOAD_KEY = "smtPayload"
    const val NOTIF_CUSTOM_PAYLOAD_KEY = "smtCustomPayload"
    const val NOTIF_SOURCE_KEY = "smtSrc"
    const val NOTIF_TITLE_KEY = "title"
    const val NOTIF_TR_ID_KEY = "trid"
    const val NOTIF_MEDIA_URL_KEY = "mediaUrl"
    const val NOTIF_IMAGE_URL_KEY = "image"
    const val NOTIF_MEDIA_LOCAL_PATH_KEY = "mediaLocalPath"
    const val NOTIF_TYPE_KEY = "type"
    const val NOTIF_BODY_KEY = "body"
    const val NOTIF_MESSAGE_KEY = "message"
    const val NOTIF_SUBTITLE_KEY = "subtitle"
    const val NOTIF_DEEPLINK_KEY = "deeplink"
    const val NOTIF_STATUS_KEY = "status"
    const val NOTIF_PN_META_KEY = "pnMeta"
    const val NOTIF_PUBLISHED_DATE_KEY = "publishedDate"
    const val NOTIF_SCHEDULED_DATE_KEY = "schDt"
    const val NOTIF_TTL_KEY = "ttl"
    const val NOTIF_COLLAPSE_KEY = "collapseKey"
    const val NOTIF_STICKEY_ENABLED_KEY = "spn"
    const val NOTIF_STICKY_ENABLED = "stickyEnabled"

    const val NOTIF_SOUND_KEY = "sound"
    const val NOTIF_SOUND_FILE_KEY = "soundFile"
    const val NOTIF_CHANNEL_ID_KEY = "aChannelId"


    const val NOTIF_TITLE_HTML_KEY = "htTitle"
    const val NOTIF_MESSAGE_HTML_KEY = "htBody"
    const val NOTIF_SUB_TITLE_HTML_KEY = "htSTitle"

    // with sound
    const val NOTIF_DEFAULT_CHANNEL_ID = "smtDefault"
    const val NOTIF_DEFAULT_CHANNEL_NAME = "Smartech Default"
    const val NOTIF_DEFAULT_CHANNEL_DESCRIPTION = "Smartech default notification configuration"

    const val NOTIF_ACTION_BUTTON_KEY = "actionButton"
    const val NOTIF_ACTION_NAME_KEY = "actionName"
    const val NOTIF_ACTION_DEEPLINK_KEY = "actionDeeplink"

    const val NOTIF_CAROUSEL_KEY = "carousel"
    const val NOTIF_CAROUSEL_IMG_TITLE_KEY = "imgTitle"
    const val NOTIF_CAROUSEL_IMG_MSG_KEY = "imgMsg"
    const val NOTIF_CAROUSEL_IMG_URL_KEY = "imgUrl"
    const val NOTIF_CAROUSEL_IMG_LOCAL_PATH_KEY = "mediaLocalPath"
    const val NOTIF_CAROUSEL_IMG_DEEPLINK_KEY = "imgDeeplink"

    const val NOTIF_ACTION_ID = "actionId"

    const val NOTIF_SMT_ATTRIBUTE_PAYLOAD_KEY = "attrParams"

    // notification attribution params
    const val NOTIF_ATTRIBUTION_MEDIUM = "__stm_medium"
    const val NOTIF_ATTRIBUTION_SOURCE = "__stm_source"
    const val NOTIF_ATTRIBUTION_ID = "__stm_id"
    const val NOTIF_ATTRIBUTION_STA = "__sta"
    const val NOTIF_ATTRIBUTION_IDENTITY = "__stm_identity"
    const val NOTIF_ATTRIBUTION_UTM_CAMPAIGN = "utm_campaign"
    const val NOTIF_ATTRIBUTION_UTM_MEDIUM = "utm_medium"
    const val NOTIF_ATTRIBUTION_UTM_SOURCE = "utm_source"
    const val NOTIF_ATTRIBUTION_OTHER = "other"
    const val NOTIF_ATTRIBUTION_CM = "atcm"
    const val NOTIF_ATTRIBUTION_CI = "atci"
    const val NOTIF_ATTRIBUTION_CS = "atcs"
    const val NOTIF_ATTRIBUTION_CA = "atca"
    const val NOTIF_IS_SCHEDULED = "s"
    const val NOTIF_IS_RENDERED = "r"
    const val NOTIF_IS_CANCELLED = "c"
    const val NOTIF_IS_SCHEDULED_PN = "is_schedule_pn"
    const val NOTIF_ID = "id"
    const val NOTIF_DOWNLOAD_STATUS = "mDownloadStatus"
    const val NOTIF_SOURCE_TYPE = "sourceType"


    // Encoding
    const val NOTIF_UTF_ENCODING = "UTF-8"

}