package com.netcore.android.network

import com.netcore.android.network.models.SMTRequest
import java.util.concurrent.Callable
import java.util.concurrent.Future

/**
 * @author Netcore
 * created on 31/01/2019
 * @Description: Callable class which processes the request in a thread
 *
 */
internal class SMTRequestProcessor(private var apiRequest: SMTRequest, private var internalListener: SMTInternalNetworkListener) : Callable<Future<*>> {

    @Throws(Exception::class)
    override fun call(): Future<*>? {

        internalListener.onRequestProcessComplete(SMTApiService(apiRequest).makeApiCall())

        return null

    }


}