package com.netcore.android.inbox.views.fragment

import android.content.Context
import com.netcore.android.db.SMTDataBaseService
import com.netcore.android.inbox.network.SMTInboxApiService
import com.netcore.android.inbox.utility.SMTInboxMessageType
import com.netcore.android.listeners.SMTInboxCallback
import com.netcore.android.notification.models.SMTNotificationData
import com.netcore.android.utility.SMTManifestInfo
import java.lang.ref.WeakReference

/**
 * Presenter class for the InboxFragment
 *
 * @author Netcore
 * @version 1.0
 * @since 02-05-2019
 */
internal class SMTInboxPresenter(val view: SMTInboxContract.View, val context: Context) : SMTInboxContract.Presenter {

    var notifications: MutableList<SMTNotificationData>? = null


    /**
     * Method to decide whether to make API call
     * or fetch data from Database
     */
    override fun getInboxMessages() {
        var makeApiCall = false
        if (SMTManifestInfo.getInstance(WeakReference(context)).isAutoFecthInboxNotifications == 0) {
            makeApiCall = true
        }
        if (!makeApiCall) {
            notifications = SMTDataBaseService.getInstance(WeakReference(context)).getInboxMessages(SMTInboxMessageType.Type.INBOX_MESSAGE)
        }
        if (notifications?.isEmpty() == true) {
            makeApiCall = true
        }

        if (makeApiCall) {
            view.showLoading(true)
            getInboxNotificationsWithCallBack()
        } else {
            view.showNotifications(notifications)
        }
    }

    /**
     * Performs Inbox API call and updates the UI as per data received
     */
    private fun getInboxNotificationsWithCallBack() {
        SMTInboxApiService.getInstance(WeakReference(context)).makeAppInboxApiCall(object : SMTInboxCallback {
            override fun onInboxProgress() {
                view.showLoading(true)
            }

            override fun onInboxSuccess(allInboxNotifications: MutableList<SMTNotificationData>?) {
                view.showLoading(false)
                notifications = SMTDataBaseService.getInstance(WeakReference(context)).getInboxMessages(SMTInboxMessageType.Type.INBOX_MESSAGE)
                view.showNotifications(notifications)
            }

            override fun onInboxFail() {
                view.showLoading(false)
            }
        }, SMTInboxMessageType.Type.INBOX_MESSAGE)
    }
}