package com.netcore.android.smartech.userprofile /* DE-DUP PROFILE BLOCK 3 of 4 */

import android.content.Context
import com.netcore.android.preference.SMTPreferenceConstants
import com.netcore.android.preference.SMTPreferenceHelper
import com.netcore.android.utility.encryption.SMTEncryption
import java.lang.ref.WeakReference

internal class SMTUserProfile private constructor(val context: WeakReference<Context>) {
    companion object {
        @Volatile
        private var INSTANCE: SMTUserProfile? = null
        var mSMTPreferenceHelper: SMTPreferenceHelper? = null

        fun getInstance(context: WeakReference<Context>): SMTUserProfile = INSTANCE
                ?: synchronized(SMTUserProfile::class.java) {
                    INSTANCE ?: buildInstance(context).also { INSTANCE = it }
                }

        private fun buildInstance(context: WeakReference<Context>): SMTUserProfile {
            context.get()?.let {
                mSMTPreferenceHelper = SMTPreferenceHelper.getAppPreferenceInstance(it, null)
            }
            return SMTUserProfile(context)
        }
    }

    /**
     * This method compares the MD5 Hash of user identity and profile payload with the preference MD5 Hash of user profile data.
     * It will save the generated MD5 Hash in preferences and return true if the MD5 Hashes are different.
     * @param userProfileData - User profile payload data.
     * */
    fun shouldSyncUserProfile(userProfileData: HashMap<String, Any>): Boolean {
        val currentUserProfileMD5Hash = mSMTPreferenceHelper?.getString(SMTPreferenceConstants.SMT_USER_PROFILE_MD5_HASH)
                ?: ""
        val currentUserIdentity = mSMTPreferenceHelper?.getString(SMTPreferenceConstants.SMT_USER_IDENTITY)
                ?: ""
        val generatedProfileMD5 = SMTEncryption.getMD5FromString("$currentUserIdentity;$userProfileData")

        return when (currentUserProfileMD5Hash != generatedProfileMD5) {
            true -> {
                mSMTPreferenceHelper?.setString(SMTPreferenceConstants.SMT_USER_PROFILE_MD5_HASH, generatedProfileMD5)
                true
            }
            false -> false
        }
    }
}