package com.netcore.android.network.parser

import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.SMTInAppResponse
import org.json.JSONObject

class SMTInAppParser {

    private val TAG = SMTInAppParser::class.java.simpleName
    private val KEY_INAPP_DATA = "data"
    private val KEY_INAPP_MESSAGE = "message"
    private val KEY_INAPP_STATUS = "status"

    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTInAppResponse {

        val inAppResponse = SMTInAppResponse()

        // If response is null then return default SMTInAppResponse
        if (networkResponse.response == null) {
            SMTLogger.v("SMTInAppParser", "InApp list seg response is null")
            return inAppResponse
        }

        inAppResponse.smtApiTypeID = networkResponse.apiID

        try {

            val inAppData = JSONObject(networkResponse.response)
            SMTLogger.v("InApp : list and segment", "$inAppData")
            inAppResponse.inAppListSegmentData = SMTInAppResponse.InAppListSegmentData()
            inAppResponse.inAppListSegmentData?.data = inAppData.optJSONObject(KEY_INAPP_DATA)
            inAppResponse.inAppListSegmentData?.message = inAppData.optString(KEY_INAPP_MESSAGE)
            inAppResponse.inAppListSegmentData?.status = inAppData.optInt(KEY_INAPP_STATUS, 0)

        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        }
        return inAppResponse
    }
}