package com.netcore.android.mediadownloader

import android.content.Context
import android.os.AsyncTask
import com.netcore.android.logger.SMTLogger
import com.netcore.android.notification.SMTNotificationType
import com.netcore.android.notification.models.SMTCarouselItemData
import java.lang.ref.WeakReference

/**
 * @author Netcore
 * created on 31/01/2019
 * @Description:  An async task to download the carousel image
 * @param context  Context
 * @param carouselItem SMTCarouselItemData
 * @param listener AsyncDownloadListener
 */
internal class SMTCarouselDownloadAsyncTask(val context: WeakReference<Context>, var carouselItem: SMTCarouselItemData, val listener: SMTMediaDownloadManager.AsyncDownloadListener) : AsyncTask<Unit, Unit, SMTCarouselItemData>() {

    override fun doInBackground(vararg p0: Unit?): SMTCarouselItemData? {
        SMTLogger.d("CarouselDownloadAsyncTask", "Async started to download carousel notifications")
        /**
         *  downloading
         */
        context.get()?.let {
            downloadMedia(carouselItem, it)
        }

        return carouselItem

    }

    private fun downloadMedia(carouselItem: SMTCarouselItemData, context: Context) {
        var filePath: String? = SMTImageDownloader(context, carouselItem.imgUrl, SMTNotificationType.CAROUSEL.type).download()

        if (filePath.isNullOrEmpty()) {
            carouselItem.mDownloadStatus == SMTMediaDownloadManager.DownloadStatus.FAILED.value
        } else {
            carouselItem.mMediaLocalPath = filePath
        }
    }

    override fun onPostExecute(carouselItem: SMTCarouselItemData) {
        super.onPostExecute(carouselItem)

        return if (!carouselItem.mMediaLocalPath.isNullOrEmpty()) {
            listener.onCarouselDownloadSuccess(carouselItem)
        } else {
            listener.onCarouselDownloadError(carouselItem)
        }
    }

}