package com.netcore.android.logger;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SMTDebugLevel {

    @Keep
    @IntDef({Level.VERBOSE, Level.DEBUG, Level.INFO,
            Level.WARN, Level.ERROR, Level.FATAL, Level.NONE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Level {
        int VERBOSE = 1;
        int DEBUG = 2;
        int INFO = 3;
        int WARN = 4;
        int ERROR = 5;
        int FATAL = 6;
        int NONE = 7;
    }
}
