package com.netcore.android.network

import android.content.Context
import android.net.ConnectivityManager
import android.net.Network
import android.net.NetworkCapabilities
import android.os.Build
import com.netcore.android.logger.SMTLogger


internal object SMTNetworkUtil {
    /**
     * Check if mobile is connected to internet or not
     */
    fun hasInternetConnection(context: Context): Boolean {
        val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val networkInfo = connectivityManager.activeNetworkInfo
        SMTLogger.internal("SMTNetworkUtil", "Value of networkInfo : $networkInfo")
        return networkInfo?.isConnected == true
    }

    /**
     *  Method will return status on network connection
     *  @param context app
     *  @return Boolean status of connection
     */
    fun hasInternetConnectionAvailable(context: Context): Boolean {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

            if (connectivityManager == null) {
                SMTLogger.v("NetworkUtil", "connectivityManager is null")
            } else {
                SMTLogger.v("NetworkUtil", "connectivityManager not is null")
            }


            val network: Network = connectivityManager.activeNetwork

            if (network == null) {
                SMTLogger.v("NetworkUtil", "network is null")
            } else {
                SMTLogger.v("NetworkUtil", "network not is null")
            }
            val capabilities = connectivityManager
                    .getNetworkCapabilities(network)
            (capabilities != null
                    && capabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_VALIDATED))
        } else {
            true
        }
    }
}