package com.netcore.android.inbox.utility

import android.graphics.Canvas
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.graphics.drawable.Drawable
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.RecyclerView

internal class SMTRecyclerSwipeController(private val swipeActions: SMTSwipeControllerActions, private val icon: Drawable) : ItemTouchHelper.Callback() {

    private val background: ColorDrawable = ColorDrawable(Color.RED)

    override fun getMovementFlags(recyclerView: RecyclerView, viewHolder: RecyclerView.ViewHolder): Int {
        return ItemTouchHelper.Callback.makeMovementFlags(0, ItemTouchHelper.LEFT)
    }

    override fun onMove(recyclerView: RecyclerView, viewHolder: RecyclerView.ViewHolder, target: RecyclerView.ViewHolder): Boolean {
        return false
    }

    override fun onSwiped(viewHolder: RecyclerView.ViewHolder, direction: Int) {
        val position = viewHolder.adapterPosition
        swipeActions.onRightSwiped(position)
    }

    override fun onChildDraw(c: Canvas, recyclerView: androidx.recyclerview.widget.RecyclerView, viewHolder: androidx.recyclerview.widget.RecyclerView.ViewHolder, dX: Float, dY: Float, actionState: Int, isCurrentlyActive: Boolean) {
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive)
        val itemView = viewHolder.itemView

//        val iconMargin = (itemView.height - icon.intrinsicHeight) / 2
        val iconTop = itemView.top + (itemView.height - icon.intrinsicHeight) / 2
        val iconBottom = iconTop + icon.intrinsicHeight

        val iconLeft = itemView.right - 30 - icon.intrinsicWidth
        val iconRight = itemView.right - 30
        icon.setBounds(iconLeft, iconTop, iconRight, iconBottom)

        when {
            dX > 0 -> // Swiping to the right
                icon.setBounds(iconLeft, iconTop, iconRight, iconBottom)
            dX < 0 -> // Swiping to the left
                icon.setBounds(iconLeft, iconTop, iconRight, iconBottom)
            else -> // view is unSwiped
                background.setBounds(0, 0, 0, 0)
        }
        icon.draw(c)
    }
}