package com.netcore.android.utility.xiaomi

import android.util.Pair

class SMTXiaomiUtility {
    companion object {

        /**
         * This method converts the input trid to Xiaomi topic TRID.
         * The method will take substring of input TRID upto last index of "-". Then "-XR" will be appended to substring.
         * @param trid - TRID that is to be converted.
         * */
        fun convertToXiaomiTopicTrid(trid: String): String {
            val lastIndex = trid.lastIndexOf("-")
            return trid.substring(0, lastIndex) + "-XR"
        }

        /**
         * If trid ends with "AR" or "IR", this method will return substring of trid from 0 to last index of "-".
         * Else it will return the same trid.
         * The first value of pair indicates if trid is changed or not.
         * The second value of pair is the trid to be return.
         *
         * @param trid - trid to be processed.
         */
        fun parseTrid(trid: String): Pair<Boolean, String> {
            if (trid.endsWith("XR")) {
                val lastIndex = trid.lastIndexOf("-")
                return Pair(true, trid.substring(0, lastIndex))
            }
            return Pair(false, trid)
        }
    }
}