package com.netcore.android.notification.channel

data class SMTNotificationChannel(
        val channelId: String,
        val channelName: CharSequence,
        val importance: Int,

        val channelDescription: String?,
        val ChannelGroupId: String?,
        val notificationSound: String?
) {

    class Builder(
            private var channelId: String,
            private var channelName: CharSequence,
            private var importance: Int) {

        private var channelDescription: String = ""
        private var channelGroupId: String = ""
        private var notificationSound: String = ""

        fun setChannelDescription(channelDescription: String) = apply { this.channelDescription = channelDescription }
        fun setChannelGroupId(channelGroupId: String) = apply { this.channelGroupId = channelGroupId }
        fun setNotificationSound(notificationSound: String) = apply { this.notificationSound = notificationSound }

        fun build() = SMTNotificationChannel(channelId, channelName, importance,
                channelDescription, channelGroupId, notificationSound)
    }
}