package com.netcore.android.notification.carousel

import android.content.Context
import android.content.ContextWrapper
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.Drawable
import com.netcore.android.logger.SMTLogger
import java.io.*

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Singleton Carousel Utility class
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal object SMTCarouselUtility {

    val TAG = SMTCarouselUtility::class.java.simpleName

    /**
     * Converts Drawable to bitmap
     * @param drawable - The drawable which needs to be converted to bitmap
     * @return Bitmap - Returns bitamp after converting the drawable to bitmap
     */
    fun carouselDrawableToBitmap(drawable: Drawable): Bitmap {

        var bitmap: Bitmap? = if (drawable.intrinsicWidth <= 0 || drawable.intrinsicHeight <= 0) {
            Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888) // Single color bitmap will be created of 1x1 pixel
        } else {
            Bitmap.createBitmap(drawable.intrinsicWidth, drawable.intrinsicHeight, Bitmap.Config.ARGB_8888)
        }

        if (drawable is BitmapDrawable) {
            if (drawable.bitmap != null) {
                return drawable.bitmap
            }
        }

        val canvas = Canvas(bitmap!!)
        drawable.setBounds(0, 0, canvas.width, canvas.height)
        drawable.draw(canvas)
        return bitmap
    }

    /*fun carouselGetAppIconResourceId(context: Context): Int {
        var appIconResId = -1
        val packageName = context.packageName
        val pm = context.packageManager
        val applicationInfo: ApplicationInfo
        try {
            applicationInfo = pm.getApplicationInfo(packageName, PackageManager.GET_META_DATA)
            appIconResId = applicationInfo.icon
        } catch (e: PackageManager.NameNotFoundException) {
        }

        return appIconResId
    }*/

    /*fun carouselGetApplicationName(context: Context): String {
        val applicationInfo = context.applicationInfo
        val stringId = applicationInfo.labelRes
        return if (stringId == 0) applicationInfo.nonLocalizedLabel.toString() else context.getString(stringId)
    }*/

    fun carouselSaveBitmapToInternalStorage(context: Context, bitmapImage: Bitmap, fileName: String): String? {
        var fileSaved = false
        val cw = ContextWrapper(context.applicationContext)
        // path to /data/data/yourapp/app_data/imageDir
        val directory = cw.getDir("imageDir", Context.MODE_PRIVATE)
        // Create imageDir
        val mypath = File(directory, "$fileName.jpg")

        var fos: FileOutputStream? = null
        try {
            fos = FileOutputStream(mypath)
            bitmapImage.compress(Bitmap.CompressFormat.PNG, 100, fos)
            fileSaved = true
        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        } finally {
            try {
                fos!!.close()
            } catch (e: IOException) {
                SMTLogger.e(TAG, e.message.toString())
            }

        }
        return if (fileSaved)
            directory.absolutePath
        else
            null
    }

    fun carouselLoadImageFromStorage(path: String, fileName: String): Bitmap? {
        var b: Bitmap? = null

        try {
            val f = File(path, "$fileName.jpg")
            b = BitmapFactory.decodeStream(FileInputStream(f))
        } catch (e: FileNotFoundException) {
            SMTLogger.e(TAG, e.message.toString())
        }

        return b
    }

    fun carouselCalculateInSampleSize(
            width: Int, height: Int, reqWidth: Int, reqHeight: Int): Int {
        var inSampleSize = 1

        if (height > reqHeight || width > reqWidth) {

            val halfHeight = height / 2
            val halfWidth = width / 2

            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2
            }
        }

        return inSampleSize
    }
}