package com.netcore.android.workmgr

import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters
import com.google.gson.Gson
import com.netcore.android.notification.SMTNotificationConstants
import com.netcore.android.notification.SMTNotificationGeneratorProvider
import com.netcore.android.notification.SMTPNHandler
import com.netcore.android.notification.SMTScheduleNotification

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Handles the incoming notification
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */

class SMTScheduledPNWorker(appContext: Context, workerParams: WorkerParameters) :
        Worker(appContext, workerParams) {
    private val TAG = SMTScheduledPNWorker::class.simpleName

    override fun doWork(): Result {

        val mSmtNotification = SMTScheduleNotification()
        val mScheduledPNData = inputData.getString(NOTIFICATION_DATA)
        val mSourceType = inputData.getInt(SOURCE_TYPE, 0)

        if (mScheduledPNData != null) {
            val schedulePNModel = mSmtNotification.getNotificationModel(mScheduledPNData, mSourceType)
            if (schedulePNModel != null) {
                SMTPNHandler(SMTNotificationGeneratorProvider()).handleNotification(applicationContext, mScheduledPNData, mSourceType,
                        false)
                mSmtNotification.updateScheduledNotification(applicationContext, schedulePNModel.mTrid, SMTNotificationConstants.NOTIF_IS_RENDERED)
//                SMTLogger.d(TAG, "SchedulePN Work DONE")
            }
        }
        return Result.success()
    }

    companion object {
        const val NOTIFICATION_DATA = "notification_data"
        const val SOURCE_TYPE = "source_type"

    }
}