package com.netcore.android.utility

import android.content.Context
import java.lang.ref.WeakReference


/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * This class holds info about Network, and Device details
 * and also Application info as well
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */

internal class SMTInfo private constructor(val context: WeakReference<Context>) {
    var mNetworkInfo: SMTNetworkInfo? = null

    var mDeviceInfo: SMTDeviceInfo? = null

    var mAppInfo: SMTAppInfo? = null

    init {
        context.get()?.let {
            mAppInfo = SMTAppInfo(it)
            mNetworkInfo = SMTNetworkInfo(it)
            mDeviceInfo = SMTDeviceInfo(it)
        }
    }

    companion object {
        @Volatile
        private var INSTANCE: SMTInfo? = null

        /**
         * Getting instance of the class
         */
        fun getInstance(context: WeakReference<Context>): SMTInfo =
                INSTANCE
                        ?: synchronized(SMTInfo::class.java) {
                            INSTANCE
                                    ?: buildInstance(context).also { INSTANCE = it }
                        }

        private fun buildInstance(context: WeakReference<Context>): SMTInfo {
            return SMTInfo(context)
        }

        fun resetInstance() {
            INSTANCE = null
        }
    }

    fun enableNetworkStateListener(isForeground: Boolean) {
        if (isForeground) {
            mNetworkInfo?.onAppForeground()
        } else {
            mNetworkInfo?.onAppBackground()
        }

    }
}