package com.netcore.android.network

import com.netcore.android.network.models.SMTRequest

/**
 * @author Netcore
 * created on 31/01/2019
 * @Description: This is a class for all network related requests. which sdk components can make use of
 *
 */
internal open class SMTNetworkManager private constructor() {

    companion object {
        lateinit var smtRequestQueue: SMTRequestQueue

        @Volatile
        private var INSTANCE: SMTNetworkManager? = null
        var MAX_RETRY_COUNT: Int = 2

        fun getInstance(smtRequestQueue: SMTRequestQueue): SMTNetworkManager =
                INSTANCE ?: synchronized(SMTNetworkManager::class.java) {
                    INSTANCE ?: buildInstance(smtRequestQueue).also { INSTANCE = it }
                }

        private fun buildInstance(smtRequestQueue: SMTRequestQueue): SMTNetworkManager {
            this.smtRequestQueue = smtRequestQueue
            return SMTNetworkManager()
        }
    }

    /**
     * processes the api request
     */
    fun processRequest(request: SMTRequest) {
        smtRequestQueue.addRequest(request)
    }
}