package com.netcore.android.network

import com.netcore.android.network.models.SMTRequest
import com.netcore.android.network.models.SMTResponse
import com.netcore.android.network.parser.SMTResponseParser

internal class SMTApiService(private var apiRequest: SMTRequest) {

    fun makeApiCall(): SMTResponse {

        /**
         * making api call
         */
        var mResponse = SMTResponse()
        var networkResponse = SMTHttpRequestClient().makeNetworkCall(apiRequest)
        if (networkResponse.isSuccess) {
            var response: SMTResponse? = SMTResponseParser().parse(networkResponse, apiRequest.getAPITypeID())
            if (response == null) {

                mResponse.isSuccess = false

            } else {
                mResponse = response
            }
        } else {
            mResponse.errorMessage = networkResponse.errorMessage
        }
        mResponse.requestId = apiRequest.getRequestId()
        mResponse.httpCode = networkResponse.httpCode
        mResponse.isSuccess = networkResponse.isSuccess
        mResponse.shouldRetry = networkResponse.shouldRetry
        mResponse.smtApiTypeID = apiRequest.getAPITypeID()

        return mResponse
    }
}