package com.netcore.android.inapp

import com.netcore.android.SMTInAppConst
import com.netcore.android.inapp.model.SMTInAppRule
import com.netcore.android.logger.SMTLogger
import com.netcore.android.utility.trim
import org.json.JSONObject

internal class SMTInAppRuleParser {
    private val TAG = SMTInAppRuleParser::class.java.simpleName

    /**
     * Method parses the stored rule to fetch the required parameters
     */

    fun parseStoredRule(payload: String, inAppRule: SMTInAppRule) {
        inAppRule.payload = payload
        val rule = JSONObject(payload)
        try {
            try {
                inAppRule.contentType = rule.optInt("contentType")
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.controlGroup = rule.optInt("controlGroup")
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.frequency = rule.optString("frequency")
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.frequencyType = rule.optString("frequencyType")
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.modifiedDate = SMTInAppUtility.getTimeInMilliSecForModifiedDate(rule.optString("modifiedDate"))
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //processing whatTo object
            try {
                val whatToObject = rule.optJSONObject("whatTo")
                val whatTo: SMTInAppRule.WhatTo = SMTInAppRule.WhatTo()
                whatTo.url = whatToObject.optString("url")
                inAppRule.whatTo = whatTo
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //Processing whenTo object
            try {
                val whenToObject = rule.optJSONObject("whenTo")
                val whenTo: SMTInAppRule.WhenTo = SMTInAppRule.WhenTo()
                //processing days
                try {
                    val daysArray = whenToObject.optJSONArray("days")
                    if (daysArray != null && daysArray.length() > 0) {
                        whenTo.days = ArrayList()
                        for (i in 0 until daysArray.length()) {
                            val days = daysArray.optString(i)
                            whenTo.days.add(days)
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }
                //processing time
                try {
                    val timeArray = whenToObject.optJSONArray("time")
                    if (timeArray != null && timeArray.length() > 0) {
                        whenTo.time = ArrayList()
                        for (i in 0 until timeArray.length()) {
                            val timeObject: JSONObject = timeArray.opt(i) as JSONObject
                            whenTo.time.add(createTime(timeObject))
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }
                inAppRule.whenTo = whenTo
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //processing whereTo object
            try {
                val whereToObject = rule.optJSONObject("whereTo")
                val whereTo: SMTInAppRule.WhereTo = SMTInAppRule.WhereTo()
                try {
                    whereTo.position = whereToObject.optString("position")
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }
                //processing trigger
                try {
                    val triggerObject = whereToObject.optJSONObject("trigger")
                    if (triggerObject != null) {
                        whereTo.trigger = SMTInAppRule.Rules()
                        try {
                            whereTo.trigger.eventName = inAppRule.eventName
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }
                        try {
                            whereTo.trigger.eventId = inAppRule.eventId
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }
                        try {
                            whereTo.trigger.filterType = triggerObject.optString("filterType")
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }

                        try {
                            //processing filter
                            val filterArray = triggerObject.optJSONArray("filters")
                            if (filterArray != null && filterArray.length() > 0) {
                                whereTo.trigger.filters = ArrayList()
                                for (i in 0 until filterArray.length()) {
                                    val filterObject: JSONObject = filterArray.opt(i) as JSONObject
                                    whereTo.trigger.filters.add(createFilter(filterObject))
                                }
                            }
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }
                inAppRule.whereTo = whereTo
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //Processing whomTo object
            try {
                val whomToObject = rule.optJSONObject("whomTo")
                val whomTo: SMTInAppRule.WhomTo = SMTInAppRule.WhomTo()
                //processing segIds
                try {
                    val segIdsArray = whomToObject.optJSONArray("segIds")
                    if (segIdsArray != null && segIdsArray.length() > 0) {
                        whomTo.segIds = ArrayList()
                        for (i in 0 until segIdsArray.length()) {
                            val segIds = segIdsArray.optString(i)
                            whomTo.segIds.add(segIds)
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }

                //processing listIds
                try {
                    val listIdsArray = whomToObject.optJSONArray("listIds")
                    if (listIdsArray != null && listIdsArray.length() > 0) {
                        whomTo.listIds = ArrayList()
                        for (i in 0 until listIdsArray.length()) {
                            val listIds = listIdsArray.optString(i)
                            whomTo.listIds.add(listIds)
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }

                try {
                    whomTo.visitor = whomToObject.optString("visitor")
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }

                try {
                    whomTo.visitorType = whomToObject.optString("visitorType")
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }

                //processing events
                try {
                    val eventsObject = whomToObject.optJSONObject("events")
                    if (eventsObject != null) {
                        whomTo.events = SMTInAppRule.Events()

                        try {
                            whomTo.events.targetRule = eventsObject.optString("targetRule")
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }

                        //processing rules
                        try {
                            val rulesArray = eventsObject.optJSONArray("rules")
                            if (rulesArray != null && rulesArray.length() > 0) {
                                whomTo.events.rules = ArrayList()
                                for (i in 0 until rulesArray.length()) {
                                    val rulesObject: JSONObject = rulesArray.opt(i) as JSONObject
                                    whomTo.events.rules.add(createMultiEventsRules(rulesObject))
                                }
                            }
                        } catch (e: Exception) {
                            //SMTLogger.e(TAG, e.message.toString())
                        }
                    }
                } catch (e: Exception) {
                    //SMTLogger.e(TAG, e.message.toString())
                }

                inAppRule.whomTo = whomTo
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
    }

    fun parseRule(rule: JSONObject): SMTInAppRule {
        val inAppRule = SMTInAppRule()
        inAppRule.payload = rule.toString()
        try {
            inAppRule.id = rule.optString(SMTInAppConst.KEY_ID)

            try {
                inAppRule.toDate = SMTInAppUtility.getTimeInMilliSec(rule.optString(SMTInAppConst.KEY_TO_DATE))
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }
            try {
                inAppRule.fromDate = SMTInAppUtility.getTimeInMilliSec(rule.optString(SMTInAppConst.KEY_FROM_DATE))
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.contentType = rule.optInt(SMTInAppConst.KEY_CONTENT_TYPE)
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.controlGroup = rule.optInt(SMTInAppConst.KEY_CONTROL_GROUP)
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.frequency = rule.optString(SMTInAppConst.KEY_FREQUENCY)
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.frequencyType = rule.optString(SMTInAppConst.KEY_FREQUENCY_TYPE)
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            try {
                inAppRule.modifiedDate = SMTInAppUtility.getTimeInMilliSecForModifiedDate(rule.optString(SMTInAppConst.KEY_MODIFIED_DATE))
            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //processing whatTo object
            try {
                val whatToObject = rule.optJSONObject(SMTInAppConst.KEY_WHAT_TO)
                whatToObject?.let {
                    inAppRule.whatTo = SMTInAppRule.WhatTo()
                    try {
                        inAppRule.whatTo.url = whatToObject.optString(SMTInAppConst.KEY_URL)
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }
                }

            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //Processing whenTo object
            try {
                val whenToObject = rule.optJSONObject(SMTInAppConst.KEY_WHEN_TO)
                whenToObject?.let {
                    inAppRule.whenTo = SMTInAppRule.WhenTo()

                    //processing days
                    try {
                        val daysArray = whenToObject.optJSONArray(SMTInAppConst.KEY_DAYS)
                        if (daysArray != null && daysArray.length() > 0) {
                            inAppRule.whenTo.days = ArrayList()
                            for (i in 0 until daysArray.length()) {
                                val days = daysArray.optString(i)
                                inAppRule.whenTo.days.add(days)
                            }
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }
                    //processing time
                    try {
                        val timeArray = whenToObject.optJSONArray(SMTInAppConst.KEY_TIME)
                        if (timeArray != null && timeArray.length() > 0) {
                            inAppRule.whenTo.time = ArrayList()
                            for (i in 0 until timeArray.length()) {
                                val timeObject: JSONObject = timeArray.opt(i) as JSONObject
                                inAppRule.whenTo.time.add(createTime(timeObject))
                            }
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }
                }


            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //processing whereTo object
            try {
                val whereToObject = rule.optJSONObject(SMTInAppConst.KEY_WHERE_TO)
                whereToObject?.let {
                    inAppRule.whereTo = SMTInAppRule.WhereTo()
                    try {
                        inAppRule.whereTo.position = whereToObject.optString(SMTInAppConst.KEY_POSITION)
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }

                    //processing trigger
                    try {
                        val triggerObject = whereToObject.optJSONObject(SMTInAppConst.KEY_TRIGGER)
                        if (triggerObject != null) {
                            inAppRule.whereTo.trigger = SMTInAppRule.Rules()
                            try {
                                inAppRule.eventName = triggerObject.optString(SMTInAppConst.KEY_EVENT_NAME)
                                inAppRule.whereTo.trigger.eventName = inAppRule.eventName
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }

                            try {
                                inAppRule.eventId = triggerObject.optString(SMTInAppConst.KEY_EVENT_ID)
                                inAppRule.whereTo.trigger.eventId = inAppRule.eventId
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }

                            try {
                                inAppRule.whereTo.trigger.filterType = triggerObject.optString(SMTInAppConst.KEY_FILTER_TYPE)
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }

                            //processing filter
                            try {
                                val filterArray = triggerObject.optJSONArray(SMTInAppConst.KEY_FILTERS)
                                if (filterArray != null && filterArray.length() > 0) {
                                    inAppRule.whereTo.trigger.filters = ArrayList()
                                    for (i in 0 until filterArray.length()) {
                                        val filterObject: JSONObject = filterArray.opt(i) as JSONObject
                                        inAppRule.whereTo.trigger.filters.add(createFilter(filterObject))
                                    }
                                }
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }
                }

            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

            //processing whomTo object
            try {
                val whomToObject = rule.optJSONObject(SMTInAppConst.KEY_WHOM_TO)
                whomToObject?.let {
                    inAppRule.whomTo = SMTInAppRule.WhomTo()

                    //processing listIds
                    try {
                        val listIdsArray = whomToObject.optJSONArray(SMTInAppConst.KEY_LIST_IDS)
                        if (listIdsArray != null && listIdsArray.length() > 0) {
                            inAppRule.whomTo.listIds = ArrayList()
                            for (i in 0 until listIdsArray.length()) {
                                val listIds = listIdsArray.optString(i)
                                inAppRule.whomTo.listIds.add(listIds)
                            }
                            inAppRule.isListAndSegmentPresent = true
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }

                    //processing segIds
                    try {
                        val segIdsArray = whomToObject.optJSONArray(SMTInAppConst.KEY_SEG_IDS)
                        if (segIdsArray != null && segIdsArray.length() > 0) {
                            inAppRule.whomTo.segIds = ArrayList()
                            for (i in 0 until segIdsArray.length()) {
                                val segIds = segIdsArray.optString(i)
                                inAppRule.whomTo.segIds.add(segIds)
                            }
                            inAppRule.isListAndSegmentPresent = true
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }

                    try {
                        inAppRule.whomTo.visitor = whomToObject.optString(SMTInAppConst.KEY_VISITOR)
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }

                    try {
                        inAppRule.whomTo.visitorType = whomToObject.optString(SMTInAppConst.KEY_VISITOR_TYPE)
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }

                    //processing events
                    try {
                        val eventsObject = whomToObject.optJSONObject(SMTInAppConst.KEY_EVENTS)
                        if (eventsObject != null) {
                            inAppRule.whomTo.events = SMTInAppRule.Events()

                            try {
                                inAppRule.whomTo.events.targetRule = eventsObject.optString(SMTInAppConst.KEY_TARGET_RULES)
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }

                            //processing rules
                            try {
                                val rulesArray = eventsObject.optJSONArray(SMTInAppConst.KEY_RULES)
                                if (rulesArray != null && rulesArray.length() > 0) {
                                    inAppRule.whomTo.events.rules = ArrayList()
                                    for (i in 0 until rulesArray.length()) {
                                        val rulesObject: JSONObject = rulesArray.opt(i) as JSONObject
                                        inAppRule.whomTo.events.rules.add(createMultiEventsRules(rulesObject))
                                    }
                                }
                            } catch (e: Exception) {
                                //SMTLogger.e(TAG, e.message.toString())
                            }
                        }
                    } catch (e: Exception) {
                        //SMTLogger.e(TAG, e.message.toString())
                    }
                }

            } catch (e: Exception) {
                //SMTLogger.e(TAG, e.message.toString())
            }

        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        return inAppRule
    }

    private fun createFilter(filterObject: JSONObject): SMTInAppRule.Filters {
        val filter = SMTInAppRule.Filters()
        try {
            filter.key = filterObject.optString("key").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            filter.operator = filterObject.optString("operator").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            filter.datatype = filterObject.optString("dataType").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            filter.value = filterObject.optString("value").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        return filter
    }

    private fun createTime(timeObject: JSONObject): SMTInAppRule.Time {
        val time = SMTInAppRule.Time()
        try {
            time.from = timeObject.optString("from").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            time.to = timeObject.optString("to").trim()
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        return time
    }

    private fun createMultiEventsRules(rulesObject: JSONObject): SMTInAppRule.Rules {
        val rules = SMTInAppRule.Rules()
        try {
            rules.eventId = rulesObject.optString("eventId")
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            rules.eventName = rulesObject.optString("eventName")
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            rules.waitUntil = rulesObject.optLong("waitUntil")
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            rules.performed = rulesObject.optString("performed")
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            rules.filterType = rulesObject.optString("filterType")
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        try {
            //processing filter
            val filterArray = rulesObject.optJSONArray("filters")
            if (filterArray != null && filterArray.length() > 0) {
                rules.filters = ArrayList()
                for (i in 0 until filterArray.length()) {
                    val filterObject: JSONObject = filterArray.opt(i) as JSONObject
                    rules.filters.add(createFilter(filterObject))
                }
            }
        } catch (e: Exception) {
            //SMTLogger.e(TAG, e.message.toString())
        }
        return rules
    }
}