package com.netcore.android.inapp

import android.content.Context
import com.netcore.android.SMTConfigConstants
import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTEnumHttpMethodType
import com.netcore.android.network.SMTNetworkManager
import com.netcore.android.network.SMTRequestQueue
import com.netcore.android.network.SMTResponseListener
import com.netcore.android.network.models.SMTInAppResponse
import com.netcore.android.network.models.SMTRequest
import com.netcore.android.network.models.SMTResponse
import com.netcore.android.preference.SMTGUIDPreferenceHelper
import com.netcore.android.preference.SMTPreferenceConstants
import com.netcore.android.preference.SMTPreferenceHelper
import org.json.JSONArray
import org.json.JSONObject
import java.lang.ref.WeakReference

internal class SMTInAppApiService private constructor(val context: WeakReference<Context>) : SMTResponseListener {
    private val TAG = SMTInAppApiService::class.java.simpleName

    companion object {

        @Volatile
        private var INSTANCE: SMTInAppApiService? = null

        /**
         * Getting instance of the class
         */
        //todo sharef
        fun getInstance(context: WeakReference<Context>): SMTInAppApiService =
                INSTANCE
                        ?: synchronized(SMTInAppApiService::class.java) {
                            INSTANCE
                                    ?: buildInstance(context).also { INSTANCE = it }
                        }

        private fun buildInstance(context: WeakReference<Context>): SMTInAppApiService {
            return SMTInAppApiService(context)
        }

    }

    internal fun makeListSegmentApiCall() {
        val requestBuilder = SMTRequest.Builder()
                .setHttpMethod(SMTEnumHttpMethodType.GET)
                .setBaseUrl(getListSegApiUrl())
                .setEndPoint(getListSegApiEndPoint())
                .setParams(getInAppApiParam())
                .setApiId(SMTRequest.SMTApiTypeID.LIST_SEGMENT)
                .setResponseListener(this)
        SMTNetworkManager.getInstance(SMTRequestQueue.getInstance()).processRequest(requestBuilder.build())
    }

    private fun getInAppApiParam(): JSONArray {
        val hashMap = HashMap<String, Any?>()
        val jsonArray = JSONArray()
        try {
            context.get()?.let {
                hashMap[SMTConfigConstants.REQUEST_PARAM_KEY_APP_ID] = SMTPreferenceHelper.getAppPreferenceInstance(it, null)
                        .getString(SMTPreferenceConstants.SMT_MF_APP_ID)

                val identity: String = SMTPreferenceHelper.getAppPreferenceInstance(it, null)
                        .getString(SMTPreferenceConstants.SMT_USER_IDENTITY)

                if (identity.isNotEmpty()) {
                    hashMap[SMTConfigConstants.REQUEST_PARAM_KEY_IDENTITY] = identity
                } else {
                    hashMap[SMTConfigConstants.REQUEST_PARAM_KEY_GUID] = SMTGUIDPreferenceHelper.getAppPreferenceInstance(it, null)
                            .getString(SMTPreferenceConstants.SMT_GUID, "")
                }
            }
        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        }


        return jsonArray.put(JSONObject(hashMap))
    }

    private fun getListSegApiUrl(): String {
        context.get()?.let {
            return SMTPreferenceHelper.getAppPreferenceInstance(it.applicationContext, null)
                    .getString(SMTPreferenceConstants.SMT_BASE_URL_INAPP_LIST_SEG)
        }
        return ""
    }

    private fun getListSegApiEndPoint(): String {
        return "user_attr"
    }

    override fun onResposneSuccess(response: SMTResponse) {
        proceedInAppApiSuccess(response)
    }

    override fun onResponseFailure(response: SMTResponse) {
        ////println("inapp : list and segment fail $response")
    }

    private fun proceedInAppApiSuccess(response: SMTResponse) {
        val inAppResponse = response as SMTInAppResponse

        if (inAppResponse.inAppListSegmentData != null) {
            ////println("inapp : list and segment inappResponse ${inappResponse.inappListSegmentData.toString()}")
            context.get()?.let {
                SMTPreferenceHelper.getAppPreferenceInstance(it, null)
                        .setString(SMTPreferenceConstants.SMT_LIST_SEGMENT_DATA, inAppResponse.inAppListSegmentData.toString())
            }
        }
    }
}
