package com.netcore.android.utility

import android.content.Context
import com.netcore.android.SMTEventParamKeys
import com.netcore.android.event.SMTEventId
import com.netcore.android.event.SMTEventRecorder
import com.netcore.android.event.SMTEventType
import com.netcore.android.listeners.SMTUncaughtExceptionCallback
import java.lang.ref.WeakReference

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Class to log uncaught exception
 * and throws back the same error again to App
 * in case if App wants to handle it.
 *
 * @author Netcore
 * @version 1.0
 * @since 11-03-2019
 */
class SMTUncaughtExceptionHandler(val context: Context, val handler:SMTUncaughtExceptionCallback) : Thread.UncaughtExceptionHandler {

    override fun uncaughtException(t: Thread?, e: Throwable?) {

        val hashMap = HashMap<String, Any>()
        hashMap[SMTEventParamKeys.SMT_EVENT_CRASH_MESSAGE] = " App crashed for ${t?.name} and error is $e"
        // Record App crash
        SMTEventRecorder.getInstance(context).recordEvent(SMTEventId.EVENT_APP_CRASHED,
                SMTEventId.getEventName(SMTEventId.EVENT_APP_CRASHED), hashMap, SMTEventType.EVENT_TYPE_SYSTEM)

        handler.uncaughtException(t, e)

    }
}