package com.netcore.android.mediadownloader

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import com.netcore.android.logger.SMTLogger
import java.io.InputStream
import java.net.HttpURLConnection
import java.net.URL

/**
 * @author Netcore
 * created on 31/01/2019
 * @Description: Class to download the image file
 * @param context Context
 * @param url downloadable link
 * @param type Notification type
 */
internal class SMTImageDownloader(val context: Context, val url: String?, val type: String, val isForInbox: Boolean = false) {
    val TAG: String = SMTImageDownloader::class.java.simpleName
    private var defaultImageWidth = 500;
    private var defaultImageHeight = 250;


    /**
     * Method to download the image file
     * @return filePath Stored file path
     */
    fun download(): String? {
        SMTLogger.d(TAG, "Image downloading called")
        var filePath: String? = null
        url?.let {
            var connection: HttpURLConnection? = null
            var ins: InputStream? = null
            try {
                connection = URL(url).openConnection() as HttpURLConnection
                connection.doInput = true
                connection.connect()
                ins = connection.inputStream
                var bitmap: Bitmap = BitmapFactory.decodeStream(ins)

                //scaling bitmap to ensure minimum memory usage
                val sampleSize = SMTDownloaderUtility.calculateInSampleSize(bitmap.width, bitmap.height, defaultImageWidth, defaultImageHeight)
                bitmap = Bitmap.createScaledBitmap(bitmap, bitmap.width / sampleSize, bitmap.height / sampleSize, false)
                filePath = bitmap?.let { SMTDownloaderUtility.saveBitmapToInternalStorage(bitmap, SMTDownloaderUtility.getDownloadFile(context, url, type, isForInbox)) }

            } catch (e: Exception) {
                SMTLogger.e(TAG, "Image downloading failed ${e.localizedMessage}")
            } finally {
                try {
                    connection?.disconnect()

                    ins?.close()
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }

        return filePath
    }

}