package com.netcore.android

import androidx.annotation.Keep
import java.util.concurrent.TimeUnit

internal class SMTManifestKeys {
    companion object {
        const val SMT_USE_AD_ID = "SMT_USE_AD_ID"
        //        const val SMT_IS_PN_ENABLED = "SMT_IS_PN_ENABLED"
        const val SMT_APP_ID = "SMT_APP_ID"
        const val SMT_IS_AUTO_FETCHED_LOCATION = "SMT_IS_AUTO_FETCHED_LOCATION"
        const val SMT_IS_AUTO_FETCH_INBOX_NOTIFICATIONS = "SMT_IS_AUTO_FETCH_INBOX_NOTIFICATIONS"
        const val SMT_IS_NOTIFICATION_LISTENER_ENABLED = "SMT_IS_NOTIFICATION_LISTENER_ENABLED"
    }
}

internal class SMTEventParamKeys {
    companion object {
        const val SMT_APP_VERSION = "appVersion"
        const val SMT_SDK_VERSION = "sdkVersion"
        const val SMT_APP_BUILD = "appBuild"
        const val SMT_APP_BUNDLE_ID = "appBundleId"
        const val SMT_OS_NAME = "osName"
        const val SMT_OS_VERSION = "osVersion"
        const val SMT_DEVICE_MAKE = "deviceMake"
        const val SMT_DEVICE_MODEL = "deviceModel"
        const val SMT_CARRIER = "carrier"
        const val SMT_COUNTRY_CODE = "countryCode"
        const val SMT_TIME_ZONE = "timeZone"
        const val SMT_RADIO = "radio"
        const val SMT_AD_ID = "advertiserId"
        const val SMT_VENDOR_ID = "vendorId"
        const val SMT_DEVICE_WIDTH = "deviceWidth"
        const val SMT_DEVICE_HEIGHT = "deviceHeight"
        const val SMT_DEVICE_UID = "deviceUniqueId"
        const val SMT_BOD = "bod"
        const val SMT_PUSH_TOKEN_CURRENT = "pushToken"
        const val SMT_PUSH_TOKEN_OLD = "pushTokenOld"
        const val SMT_PUSH_TOKENS = "pushTokens"
        const val SMT_REQUEST_TIME = "requestTime"
        const val SMT_USE_ADV_ID = "useAdvId"
        //        const val SMT_PN_DISABLED = "pnDisabled"
        const val SMT_NETWORK_MODE = "networkMode"
        const val SMT_APP_ID = "appId"
        const val SMT_IDENTITY = "identity"
        const val SMT_SESSION_ID = "sessionId"
        const val SMT_EVENT_ID = "eventId"
        const val SMT_EVENT_NAME = "eventName"
        const val SMT_EVENT_TIME = "eventTime"
        const val SMT_PAYLOAD = "payload"
        const val SMT_TRID = "trid"
        const val SMT_PNMETA = "pnMeta"
        const val SMT_LATITUDE = "lat"
        const val SMT_LONGITUDE = "lng"
        //const val SMT_LAUNCH_STATUS = "launchStatus"
        const val SMT_ATCM = "atcm"
        const val SMT_ATCI = "atci"
        const val SMT_ATCS = "atcs"
        const val SMT_ATCA = "atca"
        const val SMT_ATTRIBUTE_PARAMS = "attrParams"
        const val SMT_AT_OTHER = "otherAttrParams"
        const val SMT_IS_AMPLIFIED = "isAmplified"
        const val SMT_GWSOURCE = "gwSource"
        const val SMT_APN_CLICK_LINK = "apnClickLink"
        const val SMT_IN_APP_CLICK_LINK = "inAppClickLink"
        const val SMT_INBOX_CLICK_LINK = "inboxClickLink"
        const val SMT_CG = "cg"
        const val SMT_MID = "mid"
        const val SMT_CG_RANDOM_NO = "cgRandom"
        const val SMT_CG_CONTROL_GROUP = "cgControlGroup"
        const val SMT_CG_REPEAT = "cgRepeat"
        const val SMT_SCREEN_ORIENTATION = "screenOrientation"
        const val SMT_RETRY = "retry"
        const val SMT_EVENT_CRASH_MESSAGE = "errorMsg"
        const val SMT_GUID = "guid"
        const val SMT_DEVICE_LOCALE = "deviceLocale"
        const val SMT_CLEAR_IDENTITY = "clearIdentity"
        const val SMT_CAN_TRACK_REINSTALL = "canTrackRI"
        const val SMT_LATE_BIND = "lateBind"
    }
}

internal class SMTConfigConstants {
    companion object {
        // Connection read and write timeout
        const val READ_TIME_OUT = 60 * 1000 // 60 seconds
        const val WRITE_TIME_OUT = 60 * 1000 // 60 seconds

        const val OS_NAME = "android"

        val NOTIFICATION_EXPIRY_TIME = TimeUnit.DAYS.toMillis(30) // 30 days
        val MAX_CAP_PAMP_INTERVAL = TimeUnit.HOURS.toMillis(6) // 6 hrs

        // For event BOD
        const val BOD_FOR_TABLET: Int = 3602
        const val BOD_FOR_PHONE: Int = 2602

        // For screen orientation
        const val SCREEN_ORIENTATION_LANDSCAPE = "landscape"
        const val SCREEN_ORIENTATION_PORTRAIT = "portrait"

        // Permission keys
        const val LOCATION_PERMISSION_MF_KEY = "android.permission.ACCESS_FINE_LOCATION"
        const val WRITE_STORAGE_PERMISSION_MF_KEY = "android.permission.WRITE_EXTERNAL_STORAGE"
        const val READ_STORAGE_PERMISSION_MF_KEY = "android.permission.READ_EXTERNAL_STORAGE"

        // Default Smartech settings constants

        const val DEFAULT_BATCH_INTERVAL = 30 //in seconds
        const val DEFAULT_BATCH_SIZE = 5 //count
        const val DEFAULT_PUSH_AMP_INTERVAL = 15 //in minutes
        const val DEFAULT_SESSION_INTERVAL = 30 //in minutes
        const val DEFAULT_TOKEN_INTERVAL = 60 //in minutes
        const val DEFAULT_IS_FETCH_LOCATION = true
        const val DEFAULT_IS_PUSH_AMP_ENABLED = true
        const val DEFAULT_IS_PANEL_ACTIVE = false
        const val DEFAULT_IS_SDK_ACTIVE = false

        // External File Storage Path
        const val EXTERNAL_FILE_DIR = "/netcore"
        const val EXTERNAL_FILE_NAME = "netcore_guid.txt"

        // API path
        const val TRACK_API_PATH = "app/v1/track_appact"
        const val PUSHAMP_API_PATH = "app/v1/pushamp"
        const val APP_INBOX_API_PATH = "app/v1/inbox"
//        val INITIALIZE_API_PATH = "initialize"

        // Request Keys
        const val REQUEST_PARAM_KEY_APP_ID = "appid"
        const val REQUEST_PARAM_KEY_OS = "os"
        const val REQUEST_PARAM_KEY_IDENTITY = "identity"

        // Server time stamp
        const val SERVER_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss"

        // Local Broadcast event names
        const val BROADCAST_EVENT_AUDIO_DISMISS = "com.smartech.AUDIO_NOTIF_DISMISS"
        const val BROADCAST_EVENT_PN_CLICKED = "com.smartech.EVENT_PN_CLICKED"
        const val BROADCAST_EVENT_PN_DISMISSED = "com.smartech.EVENT_PN_DISMISSED"
        const val BROADCAST_EVENT_INBOX_REFRESH = "com.smartech.EVENT_INBOX_REFRESH"

        const val SMT_BROADCAST_EVENT_PN_INBOX_CLICK = "com.smartech.EVENT_PN_INBOX_CLICK"

        //Bundle Keys
        const val BUNDLE_KEY_INBOX_DISABLE_BACK = "disableBack"
    }
}

class SMTBundleKeys {
    @Keep
    companion object {
        //Bundle Keys
        const val SMT_BUNDLE_KEY_CLICK_DEEPLINK = "clickDeepLinkPath"
        const val SMT_BUNDLE_KEY_CLICK_CUSTOM_PAYLOAD = "clickCustomPayload"
    }
}

class SMTWorkManagerConst {
    companion object {
        // WorkManager
        const val SMT_PUSHAMP_WORKER_TAG = "smt_pushamp_tag"
        const val SMT_BACKGROUND_WORKER_TAG = "smt_background_tag"
        const val SMT_INPROGRESS_WORKER_TAG = "smt_inprogress_tag"
        const val SMT_EVENTSYNC_WORKER_TAG = "smt_eventsync_tag"
    }
}


internal class SmartechNotificationOptionKeys {
    companion object {
        const val SMALL_ICON_ID = "smallIconId"
        const val LARGE_ICON_ID = "largeIconId"
        const val SMALL_ICON_TRANSPARENT_ID = "smallIconTransparentId"
        const val TRANS_ICON_BG_COLOR = "transBgColor"
        const val PLACE_HOLDER_ICON = "placeHolderIcon"
        const val SOUND_URI = "soundUri"
    }
}

