package com.netcore.android

import android.content.Context
import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage

/**
 * @author Netcore
 *
 * @Description: Subclass of FirebaseMessagingService. Smartech sdk will communicate all the FirebaseMessaging events to application through this class
 * The application developer should implement this class instead of FirebaseMessagingService. The declaration of this service in the manifest should be below the @SMTFbMessagingService in the manifest declaration
 *
 *
 */
abstract class SMTFirebaseMessagingService : FirebaseMessagingService() {


    /**
     * Client has to implement a this method to receive the notification where it gives the message and @Context
     */
    abstract fun onMessageReceived(context: Context, remoteMessage: RemoteMessage?)

    /**
     * Client has to implement a this method to receive the token and @Context
     */
    abstract fun onNewToken(context: Context, token: String?)

    /**
     * Client has to implement a this method to get the onDeletedMessages callback
     */
    open fun onDeletedMessages(context: Context) {

    }

    /**
     * Client has to implement a this method to get the onMessageSent callback
     */
    open fun onMessageSent(context: Context, value: String?) {

    }

    /**
     * Client has to implement a this method to get the onSendError callback
     */
    open fun onSendError(context: Context, var1: String?, var2: Exception?) {

    }
}