package com.netcore.android.utility

import android.annotation.SuppressLint
import android.content.Context
import android.location.Location
import android.location.LocationManager
import com.netcore.android.listeners.SMTLocationCallback

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Singleton class to provides device related Info
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal class SMTFusedLocationManager(val context: Context, private val locationListener: SMTLocationCallback) {

    private val TAG = SMTFusedLocationManager::class.java.simpleName

    /**
     * Fetches last location known location of user using Fused Location Provider
     */
    @SuppressLint("MissingPermission")
    fun getLastLocation() {

        try {
            var location: Location? = null

            val locManager = context.getSystemService(Context.LOCATION_SERVICE) as LocationManager

            val providers = locManager.getProviders(true)

            var tempLocation: Location? = null
            for (provider in providers) {
                try {
                    tempLocation = locManager.getLastKnownLocation(provider)
                } catch (e: SecurityException) {
                    e.printStackTrace()
                }

                if (tempLocation == null) {
                    continue
                }
                if (location == null || tempLocation?.accuracy < location.accuracy) {
                    location = tempLocation
                }
            }
            location?.let {
                locationListener.onLocationFetchSuccess(it)
            }
                    ?: locationListener.onLocationFetchFailed(Exception("Location fetched: but value is null"))
        } catch (e: Exception) {
        }
    }
}