package com.netcore.android.logger

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Singleton class - it has exposed methods to get called
 * to print logs.
 *
 * @author Netcore
 * @version 1.0
 * @since 11-03-2019
 */
internal object SMTLogger {

    private var logPrinter: SMTPrinter

    private var mDebugLevel = SMTDebugLevel.Level.LOG_LEVEL_NONE

    private var mInternalLog = false

    init {
        logPrinter = SMTLoggerPrinter()
    }

    fun setPrinter(printer: SMTPrinter) {
        this.logPrinter = printer
    }

    fun internal(tag: String, message: String) {
        if (mInternalLog) {
            logPrinter.internal(tag, message)
        }
    }

    fun setDebugLevel(@SMTDebugLevel.Level level: Int) {
        mDebugLevel = level

        // Special case to print internal log level
        // and overwite log level to print all logs
        if (level == 9) {
            mInternalLog = true
            mDebugLevel = SMTDebugLevel.Level.LOG_LEVEL_VERBOSE
        }
    }

    fun setInternal(value: Boolean) {
        mInternalLog = value
    }

    fun d(tag: String, message: String) {
        if (mDebugLevel <= SMTDebugLevel.Level.LOG_LEVEL_DEBUG /*&& BuildConfig.isDebug*/) {
            logPrinter.d(tag, message)
        }
    }

    fun e(tag: String, message: String) {
        if (mDebugLevel <= SMTDebugLevel.Level.LOG_LEVEL_ERROR /*&& BuildConfig.isDebug*/) {
            logPrinter.e(tag, message)
        }
    }

    fun w(tag: String, message: String) {
        if (mDebugLevel <= SMTDebugLevel.Level.LOG_LEVEL_WARN/*&& BuildConfig.isDebug*/) {
            logPrinter.w(tag, message)
        }
    }

    fun i(tag: String, message: String) {
        if (mDebugLevel <= SMTDebugLevel.Level.LOG_LEVEL_INFO/*&& BuildConfig.isDebug*/) {
            logPrinter.i(tag, message)
        }
    }

    fun v(tag: String, message: String) {
        if (mDebugLevel <= SMTDebugLevel.Level.LOG_LEVEL_VERBOSE /*&& BuildConfig.isDebug*/) {
            logPrinter.v(tag, message)
        }
    }
}