package com.netcore.android.event

import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTApiService
import com.netcore.android.network.SMTNetworkManager
import com.netcore.android.network.models.SMTRequest
import com.netcore.android.network.models.SMTResponse

class SMTEventProcessor {
    val TAG = SMTEventProcessor::class.java.simpleName

    companion object {
        @Volatile
        private var INSTANCE: SMTEventProcessor? = null

        fun getInstance(): SMTEventProcessor =

                INSTANCE ?: synchronized(this) {
                    INSTANCE ?: buildInstance().also {
                        INSTANCE = it
                    }
                }

        private fun buildInstance(): SMTEventProcessor {
            return SMTEventProcessor()
        }
    }

    /**
     *  This method will process event batch and will return response
     *  @param request Event batch
     *  @return SMTResponse
     */
    fun processEvents(request: SMTRequest): SMTResponse? {
        synchronized(this) {
            request.setRetryCount(request.getRetryCount().plus(1))
            return processEventCycle(request)
        }
    }

    private fun processEventCycle(request: SMTRequest): SMTResponse? {
        var smtResponse: SMTResponse? = null
        try {
            smtResponse = SMTApiService(request).makeApiCall()
            if (smtResponse.isSuccess) {
                SMTLogger.v(TAG, "Events processed successfully.")
            } else {

                /**
                 *  If server doesn't return any response
                 *  again send events back to server
                 *  if retry count is greater then MAX_RETRY_COUNT
                 *  then do not send event and return response
                 *  back to the calling method
                 */

                if (request.getRetryCount() <= SMTNetworkManager.MAX_RETRY_COUNT) {
                    request.setRetryCount(request.getRetryCount().plus(1))
                    processEventCycle(request)
                }
            }
        } catch (e: Exception) {
            SMTLogger.v(TAG, "${e.message}")
        }
        return smtResponse
    }
}