/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.fragment;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import com.nerdscorner.mvplib.events.presenter.BaseFragmentPresenter;

public abstract class BaseFragment<P extends BaseFragmentPresenter>
extends Fragment {
    protected P presenter;

    public void onStart() {
        super.onStart();
        this.presenter.onStart();
    }

    public void onResume() {
        super.onResume();
        try {
            if (!((BaseFragmentPresenter)((Object)this.presenter)).getBus().isRegistered(this.presenter)) {
                ((BaseFragmentPresenter)((Object)this.presenter)).getBus().register(this.presenter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.presenter.onResume();
    }

    public void onPause() {
        super.onPause();
        this.presenter.onPause();
        try {
            if (((BaseFragmentPresenter)((Object)this.presenter)).getBus().isRegistered(this.presenter)) {
                ((BaseFragmentPresenter)((Object)this.presenter)).getBus().unregister(this.presenter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onStop() {
        super.onStop();
        this.presenter.onStop();
    }

    public void onDestroyView() {
        super.onDestroyView();
        try {
            this.presenter.onDestroyView();
        }
        catch (Exception exception) {
        }
        finally {
            this.presenter = null;
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        ((BaseFragmentPresenter)((Object)this.presenter)).onCreateOptionsMenu(menu, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return !this.presenter.onOptionsItemSelected(item) && super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.presenter.onConfigurationChanged(newConfig);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.presenter != null) {
            this.presenter.onSaveInstanceState(outState);
        }
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        ((BaseFragmentPresenter)((Object)this.presenter)).onViewStateRestored(savedInstanceState);
    }
}

