/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.activity;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import com.nerdscorner.mvplib.events.presenter.BaseActivityPresenter;

public class BaseActivity<P extends BaseActivityPresenter>
extends AppCompatActivity {
    protected P presenter;

    public void onStart() {
        super.onStart();
        this.presenter.onStart();
    }

    public void onResume() {
        super.onResume();
        try {
            if (!((BaseActivityPresenter)((Object)this.presenter)).getBus().isRegistered(this.presenter)) {
                ((BaseActivityPresenter)((Object)this.presenter)).getBus().register(this.presenter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.presenter.onResume();
    }

    public void onPause() {
        super.onPause();
        this.presenter.onPause();
        try {
            if (((BaseActivityPresenter)((Object)this.presenter)).getBus().isRegistered(this.presenter)) {
                ((BaseActivityPresenter)((Object)this.presenter)).getBus().unregister(this.presenter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onStop() {
        super.onStop();
        this.presenter.onStop();
    }

    public void onBackPressed() {
        if (!this.presenter.onBackPressed()) {
            super.onBackPressed();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return ((BaseActivityPresenter)((Object)this.presenter)).onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return !this.presenter.onOptionsItemSelected(item) && super.onOptionsItemSelected(item);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ((BaseActivityPresenter)((Object)this.presenter)).onActivityResult(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ((BaseActivityPresenter)((Object)this.presenter)).onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.presenter.onConfigurationChanged(newConfig);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.presenter.onSaveInstanceState(outState);
    }

    public void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        ((BaseActivityPresenter)((Object)this.presenter)).onRestoreInstanceState(savedInstanceState);
    }
}

