/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.activity;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import com.nerdscorner.mvplib.events.presenter.BaseActivityPresenter;
import com.nerdscorner.mvplib.events.presenter.BasePresenter;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseActivity<P extends BaseActivityPresenter>
extends AppCompatActivity {
    protected P presenter;

    protected void onStart() {
        super.onStart();
        ((BasePresenter)this.presenter).onStart();
    }

    protected void onResume() {
        super.onResume();
        try {
            EventBus.getDefault().register(this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((BasePresenter)this.presenter).onResume();
    }

    protected void onPause() {
        super.onPause();
        ((BasePresenter)this.presenter).onPause();
        try {
            EventBus.getDefault().unregister(this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onStop() {
        super.onStop();
        ((BasePresenter)this.presenter).onStop();
    }

    public void onBackPressed() {
        if (!((BasePresenter)this.presenter).onBackPressed()) {
            super.onBackPressed();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return !((BaseActivityPresenter)this.presenter).onCreateOptionsMenu(menu) && super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return !((BasePresenter)this.presenter).onOptionsItemSelected(item) && super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ((BaseActivityPresenter)this.presenter).onActivityResult(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ((BaseActivityPresenter)this.presenter).onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ((BasePresenter)this.presenter).onConfigurationChanged(newConfig);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ((BasePresenter)this.presenter).onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        ((BaseActivityPresenter)this.presenter).onRestoreInstanceState(savedInstanceState);
    }
}

