/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.fragment;

import android.app.Fragment;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import com.nerdscorner.mvplib.events.presenter.BaseFragmentPresenter;
import com.nerdscorner.mvplib.events.presenter.BasePresenter;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseFragment<P extends BaseFragmentPresenter>
extends Fragment {
    protected P presenter;

    public void onStart() {
        super.onStart();
        ((BasePresenter)this.presenter).onStart();
    }

    public void onResume() {
        super.onResume();
        try {
            ((BasePresenter)this.presenter).onResume();
            EventBus.getDefault().register(this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPause() {
        super.onPause();
        try {
            ((BasePresenter)this.presenter).onPause();
            EventBus.getDefault().unregister(this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onStop() {
        super.onStop();
        ((BasePresenter)this.presenter).onStop();
    }

    public void onDestroyView() {
        super.onDestroyView();
        try {
            ((BasePresenter)this.presenter).onDestroyView();
        }
        catch (Exception exception) {
        }
        finally {
            this.presenter = null;
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        ((BaseFragmentPresenter)this.presenter).onCreateOptionsMenu(menu, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return !((BasePresenter)this.presenter).onOptionsItemSelected(item) && super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ((BasePresenter)this.presenter).onConfigurationChanged(newConfig);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ((BasePresenter)this.presenter).onSaveInstanceState(outState);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        ((BaseFragmentPresenter)this.presenter).onViewStateRestored(savedInstanceState);
    }
}

