/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.FragmentManager;
import android.widget.Toast;
import com.nerdscorner.mvplib.events.activity.BaseActivity;
import com.nerdscorner.mvplib.events.view.BaseView;
import java.lang.ref.WeakReference;

public abstract class BaseActivityView
extends BaseView {
    private WeakReference<BaseActivity> activityRef;

    public BaseActivityView(@NonNull BaseActivity activity) {
        this.activityRef = new WeakReference<BaseActivity>(activity);
    }

    @Nullable
    public BaseActivity getActivity() {
        return (BaseActivity)((Object)this.activityRef.get());
    }

    @Nullable
    public FragmentManager getFragmentManager() {
        BaseActivity activity = this.getActivity();
        return activity != null ? activity.getSupportFragmentManager() : null;
    }

    public void showToast(@StringRes int textResId) {
        BaseActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Toast.makeText((Context)activity, (int)textResId, (int)0).show();
    }

    public void showToast(@StringRes int textResId, Object ... args) {
        BaseActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        Toast.makeText((Context)activity, (CharSequence)activity.getString(textResId, args), (int)0).show();
    }
}

