/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.fragment;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.v4.app.Fragment;
import com.nerdscorner.mvplib.events.presenter.BaseFragmentPresenter;
import org.greenrobot.eventbus.EventBus;

@Keep
public abstract class BaseFragment
extends Fragment {
    protected BaseFragmentPresenter presenter;

    public void onResume() {
        super.onResume();
        try {
            this.presenter.onResume();
            EventBus.getDefault().register((Object)this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPause() {
        super.onPause();
        try {
            this.presenter.onPause();
            EventBus.getDefault().unregister((Object)this.presenter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        try {
            this.presenter.onDestroyView();
        }
        catch (Exception exception) {
        }
        finally {
            this.presenter = null;
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.presenter.onConfigurationChanged(newConfig);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.presenter.onSaveInstanceState(outState);
    }
}

