/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.fragment;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.nerdscorner.mvplib.events.config.MvpConfig;
import com.nerdscorner.mvplib.events.presenter.BaseFragmentPresenter;

public abstract class BaseFragment<P extends BaseFragmentPresenter>
extends Fragment {
    protected P presenter;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        if (MvpConfig.getRegisterAt() == 1) {
            ((BaseFragmentPresenter)((Object)this.presenter)).getBus().register(this.presenter);
        }
        return view;
    }

    public void onStart() {
        super.onStart();
        if (MvpConfig.getRegisterAt() == 2) {
            ((BaseFragmentPresenter)((Object)this.presenter)).getBus().register(this.presenter);
        }
        this.presenter.onStart();
    }

    public void onResume() {
        super.onResume();
        if (MvpConfig.getRegisterAt() == 3) {
            ((BaseFragmentPresenter)((Object)this.presenter)).getBus().register(this.presenter);
        }
        this.presenter.onResume();
    }

    public void onPause() {
        super.onPause();
        this.presenter.onPause();
        if (MvpConfig.getUnregisterAt() == 3) {
            ((BaseFragmentPresenter)((Object)this.presenter)).getBus().unregister(this.presenter);
        }
    }

    public void onStop() {
        super.onStop();
        this.presenter.onStop();
        if (MvpConfig.getUnregisterAt() == 2) {
            ((BaseFragmentPresenter)((Object)this.presenter)).getBus().unregister(this.presenter);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        try {
            this.presenter.onDestroyView();
            if (MvpConfig.getUnregisterAt() == 1) {
                ((BaseFragmentPresenter)((Object)this.presenter)).getBus().unregister(this.presenter);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.presenter = null;
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        ((BaseFragmentPresenter)((Object)this.presenter)).onCreateOptionsMenu(menu, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return !this.presenter.onOptionsItemSelected(item) && super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.presenter.onConfigurationChanged(newConfig);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.presenter != null) {
            this.presenter.onSaveInstanceState(outState);
        }
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        ((BaseFragmentPresenter)((Object)this.presenter)).onViewStateRestored(savedInstanceState);
    }
}

