/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.bus;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.greenrobot.eventbus.EventBus;

public class Bus {
    private EventBus eventBus;

    private Bus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @NonNull
    public static Bus getDefaultEventBus() {
        return new Bus(EventBus.getDefault());
    }

    @NonNull
    public static Bus getNewEventBus() {
        return new Bus(new EventBus());
    }

    public static void registerDefault(@NonNull Object subscriber) {
        if (!Bus.isRegisteredDefault(subscriber)) {
            Bus.getDefaultEventBus().register(subscriber);
        }
    }

    public static void unregisterDefault(@NonNull Object subscriber) {
        Bus.getDefaultEventBus().unregister(subscriber);
    }

    public static boolean isRegisteredDefault(@NonNull Object subscriber) {
        return Bus.getDefaultEventBus().isRegistered(subscriber);
    }

    public void register(@Nullable Object subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        try {
            if (!this.isRegistered(subscriber)) {
                this.eventBus.register(subscriber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregister(@Nullable Object subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        try {
            if (this.isRegistered(subscriber)) {
                this.eventBus.unregister(subscriber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRegistered(@NonNull Object subscriber) {
        return this.eventBus.isRegistered(subscriber);
    }

    public void post(Object event) {
        this.eventBus.post(event);
    }

    public void postSticky(Object event) {
        this.eventBus.postSticky(event);
    }

    public <T> T getStickyEvent(Class<T> eventType) {
        return (T)this.eventBus.getStickyEvent(eventType);
    }

    public <T> T removeStickyEvent(Class<T> eventType) {
        return (T)this.eventBus.removeStickyEvent(eventType);
    }

    public boolean removeStickyEvent(Object event) {
        return this.eventBus.removeStickyEvent(event);
    }

    public void removeAllStickyEvents() {
        this.eventBus.removeAllStickyEvents();
    }

    public boolean hasSubscriberForEvent(Class<?> eventClass) {
        return this.eventBus.hasSubscriberForEvent(eventClass);
    }
}

