/*
 * Decompiled with CFR 0.152.
 */
package com.nerdscorner.mvplib.events.presenter;

import android.support.annotation.NonNull;
import com.nerdscorner.mvplib.events.model.BaseModel;
import com.nerdscorner.mvplib.events.view.BaseView;

public abstract class BasePresenter<V extends BaseView, M extends BaseModel> {
    protected V view;
    protected M model;

    public BasePresenter(@NonNull V view, @NonNull M model) {
        this.view = view;
        this.model = model;
    }

    public void onStart() {
        ((BaseView)this.view).onStart();
        ((BaseModel)this.model).onStart();
    }

    public void onResume() {
        ((BaseView)this.view).onResume();
        ((BaseModel)this.model).onResume();
    }

    public void onPause() {
        ((BaseView)this.view).onPause();
        ((BaseModel)this.model).onPause();
    }

    public void onStop() {
        ((BaseView)this.view).onStop();
        ((BaseModel)this.model).onStop();
    }

    public void onDestroyView() {
        ((BaseView)this.view).onDestroyView();
        ((BaseView)this.view).unbind();
    }

    public boolean onBackPressed() {
        return false;
    }
}

