/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/sentinel-core"})
@Api(tags={"\u54e8\u5175\u6838\u5fc3\u63a5\u53e3"})
public class SentinelCoreEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelCoreEndpoint.class);
    private static Converter<String, List<FlowRule>> sentinelFlowRuleParser = new Converter<String, List<FlowRule>>(){

        public List<FlowRule> convert(String source) {
            return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]);
        }
    };
    private static Converter<String, List<DegradeRule>> sentinelDegradeRuleParser = new Converter<String, List<DegradeRule>>(){

        public List<DegradeRule> convert(String source) {
            return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (Feature[])new Feature[0]);
        }
    };
    private static Converter<String, List<AuthorityRule>> sentinelAuthorityRuleParser = new Converter<String, List<AuthorityRule>>(){

        public List<AuthorityRule> convert(String source) {
            return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<AuthorityRule>>(){}, (Feature[])new Feature[0]);
        }
    };
    private static Converter<String, List<SystemRule>> sentinelSystemRuleParser = new Converter<String, List<SystemRule>>(){

        public List<SystemRule> convert(String source) {
            return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<SystemRule>>(){}, (Feature[])new Feature[0]);
        }
    };
    @Autowired
    private PluginContextAware pluginContextAware;

    @RequestMapping(path={"/update-flow-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateFlowRules(@RequestBody @ApiParam(value="\u6d41\u63a7\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        FlowRuleManager.loadRules((List)((List)sentinelFlowRuleParser.convert((Object)rule)));
        LOG.info("{} flow rules loaded...", (Object)FlowRuleManager.getRules().size());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/clear-flow-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearFlowRules() {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        LOG.info("{} flow rules cleared...", (Object)FlowRuleManager.getRules().size());
        FlowRuleManager.loadRules(new ArrayList());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/view-flow-rules"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<FlowRule>> viewFlowRules() {
        return ResponseEntity.ok().body((Object)FlowRuleManager.getRules());
    }

    @RequestMapping(path={"/update-degrade-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u964d\u7ea7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateDegradeRules(@RequestBody @ApiParam(value="\u964d\u7ea7\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        DegradeRuleManager.loadRules((List)((List)sentinelDegradeRuleParser.convert((Object)rule)));
        LOG.info("{} degrade rules loaded...", (Object)DegradeRuleManager.getRules().size());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/clear-degrade-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u964d\u7ea7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearDegradeRules() {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        LOG.info("{} degrade rules cleared...", (Object)DegradeRuleManager.getRules().size());
        DegradeRuleManager.loadRules(new ArrayList());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/view-degrade-rules"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u964d\u7ea7\u89c4\u5219\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<DegradeRule>> viewDegradeRules() {
        return ResponseEntity.ok().body((Object)DegradeRuleManager.getRules());
    }

    @RequestMapping(path={"/update-authority-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u6388\u6743\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateAuthorityRules(@RequestBody @ApiParam(value="\u6388\u6743\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        AuthorityRuleManager.loadRules((List)((List)sentinelAuthorityRuleParser.convert((Object)rule)));
        LOG.info("{} authority rules loaded...", (Object)AuthorityRuleManager.getRules().size());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/clear-authority-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u6388\u6743\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearAuthorityRules() {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        LOG.info("{} authority rules cleared...", (Object)AuthorityRuleManager.getRules().size());
        AuthorityRuleManager.loadRules(new ArrayList());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/view-authority-rules"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u89c4\u5219\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<AuthorityRule>> viewAuthorityRules() {
        return ResponseEntity.ok().body((Object)AuthorityRuleManager.getRules());
    }

    @RequestMapping(path={"/update-system-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u7cfb\u7edf\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateSystemRules(@RequestBody @ApiParam(value="\u7cfb\u7edf\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        SystemRuleManager.loadRules((List)((List)sentinelSystemRuleParser.convert((Object)rule)));
        LOG.info("{} system rules loaded...", (Object)SystemRuleManager.getRules().size());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/clear-system-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u7cfb\u7edf\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearSystemRules() {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        LOG.info("{} system rules cleared...", (Object)SystemRuleManager.getRules().size());
        SystemRuleManager.loadRules(new ArrayList());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/view-system-rules"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u89c4\u5219\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<SystemRule>> viewSystemRules() {
        return ResponseEntity.ok().body((Object)SystemRuleManager.getRules());
    }
}

