/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.GatewayType;
import com.nepxion.discovery.common.entity.InstanceEntity;
import com.nepxion.discovery.common.entity.ServiceType;
import com.nepxion.discovery.common.util.ResponseUtil;
import com.nepxion.discovery.plugin.admincenter.resource.ServiceResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/service"})
@Api(tags={"\u670d\u52a1\u63a5\u53e3"})
public class ServiceEndpoint {
    @Autowired
    private ServiceResource serviceResource;

    @RequestMapping(path={"/discovery-type"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u53d1\u73b0\u4e2d\u5fc3\u7c7b\u578b", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> discoveryType() {
        return this.doDiscoveryType();
    }

    @RequestMapping(path={"/groups"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u7ec4\u540d\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> groups() {
        return this.doGroups();
    }

    @RequestMapping(path={"/group/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u7ec4\u540d", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> group(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.doGroup(serviceId);
    }

    @RequestMapping(path={"/services"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u540d\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> services() {
        return this.doServices();
    }

    @RequestMapping(path={"/service-list"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u540d\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> serviceList(@RequestBody @ApiParam(value="\u670d\u52a1\u7c7b\u578b\u5217\u8868\u3002\u53d6\u503c\uff1a service | gateway", required=true) List<String> serviceTypes) {
        return this.doServiceList(serviceTypes);
    }

    @RequestMapping(path={"/gateways"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u7f51\u5173\u540d\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> gateways() {
        return this.doGateways();
    }

    @RequestMapping(path={"/gateway-list"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u7f51\u5173\u540d\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> gatewayList(@RequestBody @ApiParam(value="\u7f51\u5173\u7c7b\u578b\u5217\u8868\u3002\u53d6\u503c\uff1a spring-cloud-gateway | zuul", required=true) List<String> gatewayTypes) {
        return this.doGatewayList(gatewayTypes);
    }

    @RequestMapping(path={"/instances/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> instances(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.doInstances(serviceId);
    }

    @RequestMapping(path={"/instance-list/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> instanceList(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.doInstanceList(serviceId);
    }

    @RequestMapping(path={"/instance-map"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u7684Map\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> instanceMap(@RequestBody @ApiParam(value="\u670d\u52a1\u7ec4\u540d\u5217\u8868\uff0c\u4f20\u5165\u7a7a\u5217\u5219\u53ef\u4ee5\u83b7\u53d6\u5168\u90e8\u670d\u52a1\u5b9e\u4f8b\u6570\u636e", required=true) List<String> groups) {
        return this.doInstanceMap(groups);
    }

    private ResponseEntity<?> doDiscoveryType() {
        try {
            String discoveryType = this.serviceResource.getDiscoveryType().toString();
            return ResponseUtil.getSuccessResponse((Object)discoveryType);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doGroups() {
        try {
            List<String> groups = this.serviceResource.getGroups();
            return ResponseUtil.getSuccessResponse(groups);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doGroup(String serviceId) {
        try {
            String group = this.serviceResource.getGroup(serviceId);
            return ResponseUtil.getSuccessResponse((Object)group);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doServices() {
        try {
            List<String> services = this.serviceResource.getServices();
            return ResponseUtil.getSuccessResponse(services);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doServiceList(List<String> serviceTypes) {
        try {
            ArrayList<ServiceType> types = new ArrayList<ServiceType>();
            for (String serviceType : serviceTypes) {
                types.add(ServiceType.fromString((String)serviceType));
            }
            List<String> services = this.serviceResource.getServiceList(types);
            return ResponseUtil.getSuccessResponse(services);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doGateways() {
        try {
            List<String> gateways = this.serviceResource.getGateways();
            return ResponseUtil.getSuccessResponse(gateways);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doGatewayList(List<String> gatewayTypes) {
        try {
            ArrayList<GatewayType> types = new ArrayList<GatewayType>();
            for (String gatewayType : gatewayTypes) {
                types.add(GatewayType.fromString((String)gatewayType));
            }
            List<String> gatewayList = this.serviceResource.getGatewayList(types);
            return ResponseUtil.getSuccessResponse(gatewayList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doInstances(String serviceId) {
        try {
            List<ServiceInstance> instances = this.serviceResource.getInstances(serviceId);
            return ResponseUtil.getSuccessResponse(instances);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doInstanceList(String serviceId) {
        try {
            List<InstanceEntity> instanceList = this.serviceResource.getInstanceList(serviceId);
            return ResponseUtil.getSuccessResponse(instanceList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doInstanceMap(List<String> groups) {
        try {
            Map<String, List<InstanceEntity>> instanceMaps = this.serviceResource.getInstanceMap(groups);
            return ResponseUtil.getSuccessResponse(instanceMaps);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }
}

