/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.nepxion.discovery.common.delegate.DiscoveryClientDelegate;
import com.nepxion.discovery.common.entity.DiscoveryType;
import com.nepxion.discovery.common.entity.GatewayType;
import com.nepxion.discovery.common.entity.InstanceEntity;
import com.nepxion.discovery.common.entity.InstanceEntityWrapper;
import com.nepxion.discovery.common.entity.ServiceType;
import com.nepxion.discovery.plugin.admincenter.resource.ServiceResource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;

public class ServiceResourceImpl
implements ServiceResource {
    @Autowired
    private DiscoveryClient discoveryClient;

    @Override
    public DiscoveryType getDiscoveryType() {
        DiscoveryClient delegatedDiscoveryClient = null;
        delegatedDiscoveryClient = this.discoveryClient instanceof DiscoveryClientDelegate ? (DiscoveryClient)((DiscoveryClientDelegate)this.discoveryClient).getDelegate() : this.discoveryClient;
        if (delegatedDiscoveryClient instanceof CompositeDiscoveryClient) {
            CompositeDiscoveryClient compositeDiscoveryClient = (CompositeDiscoveryClient)delegatedDiscoveryClient;
            List discoveryClients = compositeDiscoveryClient.getDiscoveryClients();
            for (DiscoveryClient client : discoveryClients) {
                String discoveryDescription = client.description();
                DiscoveryType[] discoveryTypes = DiscoveryType.values();
                for (int i = 0; i < discoveryTypes.length; ++i) {
                    DiscoveryType discoveryType = discoveryTypes[i];
                    if (!discoveryDescription.toLowerCase().contains(discoveryType.toString().toLowerCase())) continue;
                    return discoveryType;
                }
            }
        } else {
            String discoveryDescription = delegatedDiscoveryClient.description();
            DiscoveryType[] discoveryTypes = DiscoveryType.values();
            for (int i = 0; i < discoveryTypes.length; ++i) {
                DiscoveryType discoveryType = discoveryTypes[i];
                if (!discoveryDescription.toLowerCase().contains(discoveryType.toString().toLowerCase())) continue;
                return discoveryType;
            }
        }
        return null;
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groupList = new ArrayList<String>();
        List<String> services = this.getServices();
        for (String service : services) {
            List<InstanceEntity> instanceEntityList = this.getInstanceList(service);
            for (InstanceEntity instance : instanceEntityList) {
                String plugin = InstanceEntityWrapper.getPlugin((InstanceEntity)instance);
                String group = InstanceEntityWrapper.getGroup((InstanceEntity)instance);
                if (!StringUtils.isNotEmpty((CharSequence)plugin) || groupList.contains(group)) continue;
                groupList.add(group);
            }
        }
        groupList.sort(String::compareTo);
        return groupList;
    }

    @Override
    public String getGroup(String serviceId) {
        List<InstanceEntity> instanceEntityList = this.getInstanceList(serviceId);
        for (InstanceEntity instance : instanceEntityList) {
            String group = InstanceEntityWrapper.getGroup((InstanceEntity)instance);
            if (!StringUtils.isNotEmpty((CharSequence)group)) continue;
            return group;
        }
        return null;
    }

    @Override
    public List<String> getServices() {
        List serviceList = this.discoveryClient.getServices();
        serviceList.sort(String::compareTo);
        return serviceList;
    }

    @Override
    public List<String> getServiceList(List<ServiceType> types) {
        ArrayList<String> serviceList = new ArrayList<String>();
        List<String> services = this.getServices();
        for (String service : services) {
            List<ServiceInstance> instances = this.getInstances(service);
            for (ServiceInstance instance : instances) {
                Map metadata = instance.getMetadata();
                String serviceId = instance.getServiceId().toLowerCase();
                String serviceType = (String)metadata.get("spring_application_type");
                for (ServiceType type : types) {
                    if (!StringUtils.equals((CharSequence)serviceType, (CharSequence)type.toString()) || serviceList.contains(serviceId)) continue;
                    serviceList.add(serviceId);
                }
            }
        }
        return serviceList;
    }

    @Override
    public List<String> getGateways() {
        ArrayList<String> gatewayList = new ArrayList<String>();
        List<String> services = this.getServices();
        for (String service : services) {
            List<ServiceInstance> instances = this.getInstances(service);
            for (ServiceInstance instance : instances) {
                Map metadata = instance.getMetadata();
                String serviceId = instance.getServiceId().toLowerCase();
                String serviceType = (String)metadata.get("spring_application_type");
                if (!StringUtils.equals((CharSequence)serviceType, (CharSequence)ServiceType.GATEWAY.toString()) || gatewayList.contains(serviceId)) continue;
                gatewayList.add(serviceId);
            }
        }
        return gatewayList;
    }

    @Override
    public List<String> getGatewayList(List<GatewayType> types) {
        ArrayList<String> gatewayList = new ArrayList<String>();
        List<String> services = this.getServices();
        for (String service : services) {
            List<ServiceInstance> instances = this.getInstances(service);
            for (ServiceInstance instance : instances) {
                Map metadata = instance.getMetadata();
                String serviceId = instance.getServiceId().toLowerCase();
                String serviceType = (String)metadata.get("spring_application_type");
                String gatewayType = (String)metadata.get("spring_application_gateway_type");
                if (!StringUtils.equals((CharSequence)serviceType, (CharSequence)ServiceType.GATEWAY.toString())) continue;
                for (GatewayType type : types) {
                    if (!StringUtils.equals((CharSequence)gatewayType, (CharSequence)type.toString()) || gatewayList.contains(serviceId)) continue;
                    gatewayList.add(serviceId);
                }
            }
        }
        return gatewayList;
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceId) {
        List instanceList = this.discoveryClient.getInstances(serviceId);
        instanceList.sort(Comparator.nullsLast(Comparator.comparing(ServiceInstance::getHost, Comparator.nullsLast(String::compareTo))).thenComparing(ServiceInstance::getPort));
        return instanceList;
    }

    @Override
    public List<InstanceEntity> getInstanceList(String service) {
        List<ServiceInstance> instances = this.getInstances(service);
        ArrayList<InstanceEntity> instanceEntityList = new ArrayList<InstanceEntity>(instances.size());
        for (ServiceInstance instance : instances) {
            Map metadata = instance.getMetadata();
            String serviceId = instance.getServiceId().toLowerCase();
            String serviceType = (String)metadata.get("spring_application_type");
            String version = (String)metadata.get("version");
            String region = (String)metadata.get("region");
            String environment = (String)metadata.get("env");
            String zone = (String)metadata.get("zone");
            String host = instance.getHost();
            int port = instance.getPort();
            InstanceEntity instanceEntity = new InstanceEntity();
            instanceEntity.setServiceType(serviceType);
            instanceEntity.setServiceId(serviceId);
            instanceEntity.setVersion(version);
            instanceEntity.setRegion(region);
            instanceEntity.setEnvironment(environment);
            instanceEntity.setZone(zone);
            instanceEntity.setHost(host);
            instanceEntity.setPort(port);
            instanceEntity.setMetadata(metadata);
            instanceEntityList.add(instanceEntity);
        }
        return instanceEntityList;
    }

    @Override
    public Map<String, List<InstanceEntity>> getInstanceMap(List<String> groups) {
        List<String> services = this.getServices();
        LinkedHashMap<String, List<InstanceEntity>> instanceMap = new LinkedHashMap<String, List<InstanceEntity>>(services.size());
        for (String service : services) {
            List<InstanceEntity> instanceEntityList = this.getInstanceList(service);
            if (CollectionUtils.isNotEmpty(groups)) {
                for (InstanceEntity instance : instanceEntityList) {
                    String plugin = InstanceEntityWrapper.getPlugin((InstanceEntity)instance);
                    String group = InstanceEntityWrapper.getGroup((InstanceEntity)instance);
                    if (!StringUtils.isNotEmpty((CharSequence)plugin) || !groups.contains(group)) continue;
                    ArrayList<InstanceEntity> instanceList = (ArrayList<InstanceEntity>)instanceMap.get(service);
                    if (instanceList == null) {
                        instanceList = new ArrayList<InstanceEntity>();
                        instanceMap.put(service, instanceList);
                    }
                    instanceList.add(instance);
                }
                continue;
            }
            instanceMap.put(service, instanceEntityList);
        }
        return instanceMap;
    }
}

