/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.nepxion.discovery.common.entity.StrategyConditionEntity;
import com.nepxion.discovery.common.entity.StrategyRouteType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.admincenter.resource.StrategyResource;
import com.nepxion.discovery.plugin.strategy.condition.StrategyCondition;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StrategyResourceImpl
implements StrategyResource {
    @Autowired
    private StrategyCondition strategyCondition;
    @Autowired
    private StrategyWrapper strategyWrapper;

    @Override
    public boolean validateExpression(String expression, String validation) {
        StrategyConditionEntity strategyConditionEntity = new StrategyConditionEntity();
        strategyConditionEntity.setExpression(expression);
        Map map = null;
        try {
            map = StringUtil.splitToMap((String)validation);
        }
        catch (Exception e) {
            throw new DiscoveryException("Invalid format for validation input");
        }
        return this.strategyCondition.isTriggered(strategyConditionEntity, map);
    }

    @Override
    public String validateRoute(String routeType, String validation) {
        StrategyRouteType strategyRouteType = StrategyRouteType.fromString((String)routeType);
        Map map = null;
        try {
            map = StringUtil.splitToMap((String)validation);
        }
        catch (Exception e) {
            throw new DiscoveryException("Invalid format for validation input");
        }
        String route = null;
        switch (strategyRouteType) {
            case VERSION: {
                route = this.strategyWrapper.getRouteVersion(map);
                break;
            }
            case REGION: {
                route = this.strategyWrapper.getRouteRegion(map);
                break;
            }
            case ADDRESS: {
                route = this.strategyWrapper.getRouteAddress(map);
                break;
            }
            case VERSION_WEIGHT: {
                route = this.strategyWrapper.getRouteVersionWeight(map);
                break;
            }
            case REGION_WEIGHT: {
                route = this.strategyWrapper.getRouteRegionWeight(map);
                break;
            }
            case ID_BLACKLIST: {
                route = this.strategyWrapper.getRouteIdBlacklist();
                break;
            }
            case ADDRESS_BLACKLIST: {
                route = this.strategyWrapper.getRouteAddressBlacklist();
            }
        }
        if (StringUtils.isEmpty(route)) {
            throw new DiscoveryException("Not found any " + routeType + " routes");
        }
        return route;
    }
}

