/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/config"})
@Api(tags={"\u914d\u7f6e\u63a5\u53e3"})
public class ConfigEndpoint {
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;

    @RequestMapping(path={"/update-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateAsync(@RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.update(config, true);
    }

    @RequestMapping(path={"/update-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateSync(@RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.update(config, false);
    }

    @RequestMapping(path={"/clear-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u6e05\u9664\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearAsync() {
        return this.clear(true);
    }

    @RequestMapping(path={"/clear-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u6e05\u9664\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearSync() {
        return this.clear(false);
    }

    @RequestMapping(path={"/view"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u672c\u5730\u548c\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<String>> view() {
        return this.view(false);
    }

    private ResponseEntity<?> update(String config, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        this.pluginEventWapper.fireRuleUpdated(new RuleUpdatedEvent(SubscriptionType.PARTIAL, config), async);
        return ResponseEntity.ok().body((Object)"OK");
    }

    private ResponseEntity<?> clear(boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        this.pluginEventWapper.fireRuleCleared(new RuleClearedEvent(SubscriptionType.PARTIAL), async);
        return ResponseEntity.ok().body((Object)"OK");
    }

    private ResponseEntity<List<String>> view(boolean async) {
        ArrayList<String> ruleList = new ArrayList<String>(3);
        String localRuleContent = "";
        RuleEntity localRuleEntity = this.pluginAdapter.getLocalRule();
        if (localRuleEntity != null && StringUtils.isNotEmpty((CharSequence)localRuleEntity.getContent())) {
            localRuleContent = localRuleEntity.getContent();
        }
        String dynamicGlobalRuleContent = "";
        RuleEntity dynamicGlobalRuleEntity = this.pluginAdapter.getDynamicGlobalRule();
        if (dynamicGlobalRuleEntity != null && StringUtils.isNotEmpty((CharSequence)dynamicGlobalRuleEntity.getContent())) {
            dynamicGlobalRuleContent = dynamicGlobalRuleEntity.getContent();
        }
        String dynamicPartialRuleContent = "";
        RuleEntity dynamicPartialRuleEntity = this.pluginAdapter.getDynamicPartialRule();
        if (dynamicPartialRuleEntity != null && StringUtils.isNotEmpty((CharSequence)dynamicPartialRuleEntity.getContent())) {
            dynamicPartialRuleContent = dynamicPartialRuleEntity.getContent();
        }
        ruleList.add(localRuleContent);
        ruleList.add(dynamicGlobalRuleContent);
        ruleList.add(dynamicPartialRuleContent);
        return ResponseEntity.ok().body(ruleList);
    }

    protected ResponseEntity<String> toExceptionResponseEntity(Exception e, boolean showDetail) {
        String message = null;
        message = showDetail ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage();
        message = "An internal error occurred while processing your request\n" + message;
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)message);
    }
}

