/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RouterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.WeightEntityWrapper;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.admincenter.resource.RouterResource;
import com.nepxion.discovery.plugin.admincenter.resource.ServiceResource;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RouterResourceImpl
implements RouterResource {
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private ServiceResource serviceResource;
    private RestTemplate routerRestTemplate = new RestTemplate();

    @Override
    public RouterEntity getRouterEntity() {
        String serviceType = this.pluginAdapter.getServiceType();
        String serviceId = this.pluginAdapter.getServiceId();
        String version = this.pluginAdapter.getVersion();
        String region = this.pluginAdapter.getRegion();
        String environment = this.pluginAdapter.getEnvironment();
        String zone = this.pluginAdapter.getZone();
        String host = this.pluginAdapter.getHost();
        int port = this.pluginAdapter.getPort();
        int weight = -1;
        String protocol = this.pluginAdapter.getProtocol();
        String contextPath = this.pluginAdapter.getFormatContextPath();
        RouterEntity routerEntity = new RouterEntity();
        routerEntity.setServiceType(serviceType);
        routerEntity.setServiceId(serviceId);
        routerEntity.setVersion(version);
        routerEntity.setRegion(region);
        routerEntity.setEnvironment(environment);
        routerEntity.setZone(zone);
        routerEntity.setHost(host);
        routerEntity.setPort(port);
        routerEntity.setWeight(weight);
        routerEntity.setProtocol(protocol);
        routerEntity.setContextPath(contextPath);
        return routerEntity;
    }

    @Override
    public List<RouterEntity> getRouterEntityList(String routeServiceId) {
        List<ServiceInstance> instanceList = null;
        try {
            instanceList = this.serviceResource.getInstances(routeServiceId);
        }
        catch (Exception e) {
            throw new DiscoveryException("Get instance list for route serviceId=" + routeServiceId + " failed", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(instanceList)) {
            return null;
        }
        ArrayList<RouterEntity> routerEntityList = new ArrayList<RouterEntity>();
        for (ServiceInstance instance : instanceList) {
            String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
            String serviceType = this.pluginAdapter.getInstanceServiceType(instance);
            String version = this.pluginAdapter.getInstanceVersion(instance);
            String region = this.pluginAdapter.getInstanceRegion(instance);
            String environment = this.pluginAdapter.getInstanceEnvironment(instance);
            String zone = this.pluginAdapter.getInstanceZone(instance);
            String host = instance.getHost();
            int port = instance.getPort();
            int weight = this.getWeight(routeServiceId, version, region);
            String protocol = this.pluginAdapter.getInstanceProtocol(instance);
            String contextPath = this.pluginAdapter.getInstanceFormatContextPath(instance);
            RouterEntity routerEntity = new RouterEntity();
            routerEntity.setServiceType(serviceType);
            routerEntity.setServiceId(serviceId);
            routerEntity.setVersion(version);
            routerEntity.setRegion(region);
            routerEntity.setEnvironment(environment);
            routerEntity.setZone(zone);
            routerEntity.setHost(host);
            routerEntity.setPort(port);
            routerEntity.setWeight(weight);
            routerEntity.setProtocol(protocol);
            routerEntity.setContextPath(contextPath);
            routerEntityList.add(routerEntity);
        }
        return routerEntityList;
    }

    @Override
    public List<RouterEntity> getRouterEntityList(String routeServiceId, String routeProtocol, String routeHost, int routePort, String routeContextPath) {
        String url = routeProtocol + "://" + routeHost + ":" + routePort + routeContextPath + "router/route/" + routeServiceId;
        String result = null;
        try {
            result = (String)this.routerRestTemplate.getForEntity(url, String.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new DiscoveryException("Failed to execute to route, serviceId=" + routeServiceId + ", url=" + url, (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        List routerEntityList = (List)JsonUtil.fromJson((String)result, (TypeReference)new TypeReference<List<RouterEntity>>(){});
        return routerEntityList;
    }

    @Override
    public RouterEntity routeTree(String routeServiceIds) {
        if (StringUtils.isEmpty((CharSequence)routeServiceIds)) {
            throw new DiscoveryException("Route serviceIds is empty");
        }
        String[] serviceIdArray = null;
        try {
            serviceIdArray = StringUtils.split((String)routeServiceIds, (String)";");
        }
        catch (Exception e) {
            throw new DiscoveryException("Route serviceIds must be separated with ';'", (Throwable)e);
        }
        RouterEntity firstRouterEntity = this.getRouterEntity();
        HashMap<Integer, List<RouterEntity>> routerEntityMap = new HashMap<Integer, List<RouterEntity>>();
        int routerDepth = 0;
        for (String serviceId : serviceIdArray) {
            serviceId = serviceId.toLowerCase().trim();
            if (routerDepth == 0) {
                this.routeFirst(firstRouterEntity, serviceId);
                this.retrieveRouterEntityList(routerEntityMap, routerDepth).addAll(firstRouterEntity.getNexts());
            } else {
                List<RouterEntity> routerEntityList = this.retrieveRouterEntityList(routerEntityMap, routerDepth - 1);
                for (RouterEntity routerEntity : routerEntityList) {
                    String routeHost = routerEntity.getHost();
                    int routePort = routerEntity.getPort();
                    String routeProtocol = routerEntity.getProtocol();
                    String routeContextPath = routerEntity.getContextPath();
                    this.route(routerEntity, serviceId, routeProtocol, routeHost, routePort, routeContextPath);
                    this.retrieveRouterEntityList(routerEntityMap, routerDepth).addAll(routerEntity.getNexts());
                }
            }
            ++routerDepth;
        }
        return firstRouterEntity;
    }

    private void routeFirst(RouterEntity routerEntity, String routeServiceId) {
        List<RouterEntity> routerEntityList = this.getRouterEntityList(routeServiceId);
        if (CollectionUtils.isNotEmpty(routerEntityList)) {
            routerEntity.getNexts().addAll(routerEntityList);
        }
    }

    private void route(RouterEntity routerEntity, String routeServiceId, String routeProtocol, String routeHost, int routePort, String routeContextPath) {
        List<RouterEntity> routerEntityList = this.getRouterEntityList(routeServiceId, routeProtocol, routeHost, routePort, routeContextPath);
        if (CollectionUtils.isNotEmpty(routerEntityList)) {
            routerEntity.getNexts().addAll(routerEntityList);
        }
    }

    private List<RouterEntity> retrieveRouterEntityList(HashMap<Integer, List<RouterEntity>> routerEntityMap, int routerDepth) {
        List<RouterEntity> routerEntityList = routerEntityMap.get(routerDepth);
        if (routerEntityList == null) {
            routerEntityList = new ArrayList<RouterEntity>();
            routerEntityMap.put(routerDepth, routerEntityList);
        }
        return routerEntityList;
    }

    private int getWeight(String providerServiceId, String providerVersion, String providerRegion) {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return -1;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return -1;
        }
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        if (weightFilterEntity == null || !weightFilterEntity.hasWeight()) {
            return -1;
        }
        String serviceId = this.pluginAdapter.getServiceId();
        return WeightEntityWrapper.getWeight((WeightFilterEntity)weightFilterEntity, (String)providerServiceId, (String)providerVersion, (String)providerRegion, (String)serviceId);
    }
}

