/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.nepxion.discovery.common.entity.InspectorEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.admincenter.resource.InspectorResource;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.client.RestTemplate;

public class InspectorResourceImpl
implements InspectorResource {
    private static final Logger LOG = LoggerFactory.getLogger(InspectorResourceImpl.class);
    @Autowired
    private RestTemplate pluginRestTemplate;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired(required=false)
    private PluginContextHolder pluginContextHolder;

    @Override
    public InspectorEntity inspect(InspectorEntity inspectorEntity) {
        List serviceIdList = inspectorEntity.getServiceIdList();
        String result = inspectorEntity.getResult();
        if (StringUtils.isEmpty((CharSequence)result) && this.pluginContextHolder != null) {
            result = this.pluginContextHolder.getContext("endpoint-inspector-inspect");
        }
        String pluginInfo = this.pluginAdapter.getPluginInfo(result);
        inspectorEntity.setResult(pluginInfo);
        if (CollectionUtils.isNotEmpty((Collection)serviceIdList)) {
            String nextServiceId = (String)serviceIdList.get(0);
            serviceIdList.remove(0);
            String url = null;
            try {
                ServiceInstance nextInstance = this.getInstance(nextServiceId);
                String protocol = this.pluginAdapter.getInstanceProtocol(nextInstance);
                String contextPath = this.pluginAdapter.getInstanceFormatContextPath(nextInstance);
                url = protocol + "://" + nextServiceId + contextPath + "inspector/inspect";
                return (InspectorEntity)this.pluginRestTemplate.postForEntity(url, (Object)inspectorEntity, InspectorEntity.class, new Object[0]).getBody();
            }
            catch (Exception e) {
                String exceptionMessage = "Failed to inspect, current serviceId=" + this.pluginAdapter.getServiceId() + ", next serviceId=" + nextServiceId + ", url=" + url;
                LOG.error(exceptionMessage, (Throwable)e);
                throw new DiscoveryException(exceptionMessage, (Throwable)e);
            }
        }
        return inspectorEntity;
    }

    private ServiceInstance getInstance(String serviceId) {
        List instances = null;
        try {
            instances = this.discoveryClient.getInstances(serviceId);
        }
        catch (Exception e) {
            throw new DiscoveryException("Failed to get instance list, serviceId=" + serviceId, (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)instances)) {
            throw new DiscoveryException("Instance list is empty, serviceId=" + serviceId);
        }
        return (ServiceInstance)instances.get(0);
    }
}

