/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.nepxion.discovery.common.entity.ConfigType;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.admincenter.resource.ConfigResource;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginConfigAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigResourceImpl
implements ConfigResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResourceImpl.class);
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired(required=false)
    private PluginConfigAdapter pluginConfigAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;

    @Override
    public ConfigType getConfigType() {
        if (this.pluginConfigAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            throw new DiscoveryException("Remote config adapter isn't provided");
        }
        return this.pluginConfigAdapter.getConfigType();
    }

    @Override
    public void update(String config, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            throw new DiscoveryException("Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            throw new DiscoveryException("Config rest control is disabled");
        }
        this.pluginEventWapper.fireRuleUpdated(new RuleUpdatedEvent(SubscriptionType.PARTIAL, config), async);
    }

    @Override
    public void clear(boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            throw new DiscoveryException("Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            throw new DiscoveryException("Config rest control is disabled");
        }
        this.pluginEventWapper.fireRuleCleared(new RuleClearedEvent(SubscriptionType.PARTIAL), async);
    }

    @Override
    public List<String> view() {
        ArrayList<String> ruleList = new ArrayList<String>(3);
        String localRuleContent = "";
        RuleEntity localRuleEntity = this.pluginAdapter.getLocalRule();
        if (localRuleEntity != null && StringUtils.isNotEmpty((CharSequence)localRuleEntity.getContent())) {
            localRuleContent = localRuleEntity.getContent();
        }
        String dynamicGlobalRuleContent = "";
        RuleEntity dynamicGlobalRuleEntity = this.pluginAdapter.getDynamicGlobalRule();
        if (dynamicGlobalRuleEntity != null && StringUtils.isNotEmpty((CharSequence)dynamicGlobalRuleEntity.getContent())) {
            dynamicGlobalRuleContent = dynamicGlobalRuleEntity.getContent();
        }
        String dynamicPartialRuleContent = "";
        RuleEntity dynamicPartialRuleEntity = this.pluginAdapter.getDynamicPartialRule();
        if (dynamicPartialRuleEntity != null && StringUtils.isNotEmpty((CharSequence)dynamicPartialRuleEntity.getContent())) {
            dynamicPartialRuleContent = dynamicPartialRuleEntity.getContent();
        }
        ruleList.add(localRuleContent);
        ruleList.add(dynamicGlobalRuleContent);
        ruleList.add(dynamicPartialRuleContent);
        return ruleList;
    }
}

