/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.RouterEntity;
import com.nepxion.discovery.common.util.ResponseUtil;
import com.nepxion.discovery.plugin.admincenter.resource.RouterResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/router"})
@Api(tags={"\u8def\u7531\u63a5\u53e3"})
public class RouterEndpoint {
    @Autowired
    private RouterResource routerResource;

    @RequestMapping(path={"/info"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u8282\u70b9\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u7b80\u5355\u4fe1\u606f", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> info() {
        return this.doInfo();
    }

    @RequestMapping(path={"/route/{routeServiceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u8282\u70b9\u53ef\u8bbf\u95ee\u5176\u4ed6\u8282\u70b9\u7684\u8def\u7531\u4fe1\u606f\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> route(@PathVariable(value="routeServiceId") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u540d", required=true) String routeServiceId) {
        return this.doNativeRoute(routeServiceId);
    }

    @RequestMapping(path={"/route/{routeServiceId}/{routeProtocol}/{routeHost}/{routePort}/{routeContextPath}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u53ef\u8bbf\u95ee\u5176\u4ed6\u8282\u70b9\u7684\u8def\u7531\u4fe1\u606f\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> route(@PathVariable(value="routeServiceId") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u540d", required=true) String routeServiceId, @PathVariable(value="routeProtocol") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u91c7\u7528\u7684\u534f\u8bae\u3002\u53d6\u503c\uff1a http | https", defaultValue="http", required=true) String routeProtocol, @PathVariable(value="routeHost") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u6240\u5728\u673a\u5668\u7684IP\u5730\u5740", required=true) String routeHost, @PathVariable(value="routePort") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u6240\u5728\u673a\u5668\u7684\u7aef\u53e3\u53f7", required=true) int routePort, @PathVariable(value="routeContextPath") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u7684\u8c03\u7528\u8def\u5f84\u524d\u7f00", defaultValue="/", required=true) String routeContextPath) {
        return this.doRemoteRoute(routeServiceId, routeProtocol, routeHost, routePort, routeContextPath);
    }

    @RequestMapping(path={"/routes"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5168\u8def\u5f84\u7684\u8def\u7531\u4fe1\u606f\u6811", notes="\u53c2\u6570\u6309\u8c03\u7528\u670d\u52a1\u540d\u7684\u524d\u540e\u6b21\u5e8f\u6392\u5217\uff0c\u8d77\u59cb\u8282\u70b9\u7684\u670d\u52a1\u540d\u4e0d\u80fd\u52a0\u4e0a\u53bb\u3002\u5982\u679c\u591a\u4e2a\u7528\u201c;\u201d\u5206\u9694\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u7a7a\u683c", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> routes(@RequestBody @ApiParam(value="\u683c\u5f0f\u793a\u4f8b\uff1aservice-a;service-b", required=true) String routeServiceIds) {
        return this.doRoutes(routeServiceIds);
    }

    private ResponseEntity<?> doInfo() {
        try {
            RouterEntity routerEntity = this.routerResource.getRouterEntity();
            return ResponseUtil.getSuccessResponse((Object)routerEntity);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doNativeRoute(String routeServiceId) {
        try {
            List<RouterEntity> routerEntityList = this.routerResource.getRouterEntityList(routeServiceId);
            return ResponseUtil.getSuccessResponse(routerEntityList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doRemoteRoute(String routeServiceId, String routeProtocol, String routeHost, int routePort, String routeContextPath) {
        try {
            List<RouterEntity> routerEntityList = this.routerResource.getRouterEntityList(routeServiceId, routeProtocol, routeHost, routePort, routeContextPath);
            return ResponseUtil.getSuccessResponse(routerEntityList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doRoutes(String routeServiceIds) {
        try {
            RouterEntity routerEntity = this.routerResource.routeTree(routeServiceIds);
            return ResponseUtil.getSuccessResponse((Object)routerEntity);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }
}

