/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.util.ResponseUtil;
import com.nepxion.discovery.plugin.admincenter.resource.ConfigResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/config"})
@Api(tags={"\u914d\u7f6e\u63a5\u53e3"})
public class ConfigEndpoint {
    @Autowired
    private ConfigResource configResource;

    @RequestMapping(path={"/config-type"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u4e2d\u5fc3\u7c7b\u578b", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> configType() {
        return this.doConfigType();
    }

    @RequestMapping(path={"/update-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u66f4\u65b0\u89c4\u5219\u914d\u7f6e", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateAsync(@RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9", required=true) String config) {
        return this.doUpdate(config, true);
    }

    @RequestMapping(path={"/update-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u66f4\u65b0\u89c4\u5219\u914d\u7f6e", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateSync(@RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9", required=true) String config) {
        return this.doUpdate(config, false);
    }

    @RequestMapping(path={"/clear-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u6e05\u9664\u89c4\u5219\u914d\u7f6e", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearAsync() {
        return this.doClear(true);
    }

    @RequestMapping(path={"/clear-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u6e05\u9664\u89c4\u5219\u914d\u7f6e", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearSync() {
        return this.doClear(false);
    }

    @RequestMapping(path={"/view"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u672c\u5730\u548c\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> view() {
        return this.doView();
    }

    private ResponseEntity<?> doConfigType() {
        try {
            String configType = this.configResource.getConfigType().toString();
            return ResponseUtil.getSuccessResponse((Object)configType);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doUpdate(String config, boolean async) {
        try {
            this.configResource.update(config, async);
            return ResponseUtil.getSuccessResponse((Object)true);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doClear(boolean async) {
        try {
            this.configResource.clear(async);
            return ResponseUtil.getSuccessResponse((Object)true);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }

    private ResponseEntity<?> doView() {
        try {
            List<String> ruleList = this.configResource.view();
            return ResponseUtil.getSuccessResponse(ruleList);
        }
        catch (Exception e) {
            return ResponseUtil.getFailureResponse((Exception)e);
        }
    }
}

