/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.resource;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.admincenter.resource.VersionResource;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.VersionClearedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionUpdatedEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionResourceImpl
implements VersionResource {
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;

    @Override
    public void update(String version, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            throw new DiscoveryException("Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            throw new DiscoveryException("Config rest control is disabled");
        }
        if (StringUtils.isEmpty((CharSequence)version)) {
            throw new DiscoveryException("Version can't be null or empty");
        }
        String dynamicVersion = null;
        String localVersion = null;
        String[] versionArray = StringUtils.split((String)version, (String)";");
        if (versionArray.length == 2) {
            dynamicVersion = versionArray[0];
            localVersion = versionArray[1];
        } else if (versionArray.length == 1) {
            dynamicVersion = versionArray[0];
        } else {
            throw new DiscoveryException("Invalid version format, it must be '${dynamicVersion}' or '${dynamicVersion};${localVersion}'");
        }
        this.pluginEventWapper.fireVersionUpdated(new VersionUpdatedEvent(dynamicVersion, localVersion), async);
    }

    @Override
    public void clear(String version, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            throw new DiscoveryException("Discovery control is disabled");
        }
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            throw new DiscoveryException("Config rest control is disabled");
        }
        if (StringUtils.isNotEmpty((CharSequence)version) && StringUtils.equals((CharSequence)version.trim(), (CharSequence)"{}")) {
            version = null;
        }
        this.pluginEventWapper.fireVersionCleared(new VersionClearedEvent(version), async);
    }

    @Override
    public List<String> view() {
        ArrayList<String> versionList = new ArrayList<String>(2);
        String localVersion = this.pluginAdapter.getLocalVersion();
        String dynamicVersion = this.pluginAdapter.getDynamicVersion();
        versionList.add(StringUtils.isNotEmpty((CharSequence)localVersion) ? localVersion : "");
        versionList.add(StringUtils.isNotEmpty((CharSequence)dynamicVersion) ? dynamicVersion : "");
        return versionList;
    }
}

