/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.configuration;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnProperty(value={"swagger.service.enabled"}, matchIfMissing=true)
public class SwaggerConfiguration {
    public static final String BASE_PACKAGE = "com.nepxion.discovery.plugin.admincenter.endpoint";
    public static final String DESCRIPTION = "Admin Center Restful APIs";
    @Value(value="${swagger.service.base.group:Nepxion Discovery}")
    private String baseGroup;
    @Value(value="${swagger.service.scan.group:}")
    private String scanGroup;
    @Value(value="${swagger.service.scan.packages:}")
    private String scanPackages;
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${swagger.service.description:Admin Center Restful APIs}")
    private String description;
    @Value(value="${swagger.service.version:3.27.0}")
    private String version;
    @Value(value="${swagger.service.license.name:Apache License 2.0}")
    private String licenseName;
    @Value(value="${swagger.service.license.url:http://www.apache.org/licenses/LICENSE-2.0}")
    private String licenseUrl;
    @Value(value="${swagger.service.contact.name:Nepxion}")
    private String contactName;
    @Value(value="${swagger.service.contact.url:https://github.com/Nepxion/Discovery}")
    private String contactUrl;
    @Value(value="${swagger.service.contact.email:1394997@qq.com}")
    private String contactEmail;
    @Value(value="${swagger.service.termsOfService.url:http://www.nepxion.com}")
    private String termsOfServiceUrl;
    @Autowired(required=false)
    private List<Parameter> swaggerHeaderParameters;
    @Autowired(required=false)
    private List<SecurityScheme> swaggerSecuritySchemes;
    @Autowired(required=false)
    private List<SecurityContext> swaggerSecurityContexts;

    @Bean(value={"discoveryDocket"})
    public Docket discoveryDocket() {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.baseGroup).apiInfo(this.apiInfo()).select().apis(SwaggerConfiguration.basePackage(BASE_PACKAGE)).paths(PathSelectors.any()).build().globalOperationParameters(this.swaggerHeaderParameters).securitySchemes(this.swaggerSecuritySchemes).securityContexts(this.swaggerSecurityContexts != null ? this.swaggerSecurityContexts : Collections.emptyList());
    }

    @Bean(value={"scanDocket"})
    @ConditionalOnProperty(name={"swagger.service.scan.group"})
    public Docket scanDocket() {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.scanGroup).apiInfo(this.apiInfo()).select().apis(SwaggerConfiguration.basePackage(this.scanPackages)).paths(PathSelectors.any()).build().globalOperationParameters(this.swaggerHeaderParameters).securitySchemes(this.swaggerSecuritySchemes).securityContexts(this.swaggerSecurityContexts != null ? this.swaggerSecurityContexts : Collections.emptyList());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.serviceName).description(this.description).version(this.version).license(this.licenseName).licenseUrl(this.licenseUrl).contact(new Contact(this.contactName, this.contactUrl, this.contactEmail)).termsOfServiceUrl(this.termsOfServiceUrl).build();
    }

    public static Predicate<RequestHandler> basePackage(final String basePackage) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return (Boolean)SwaggerConfiguration.declaringClass(input).transform(SwaggerConfiguration.handlerPackage(basePackage)).or((Object)true);
            }
        };
    }

    private static Function<Class<?>, Boolean> handlerPackage(final String basePackage) {
        return new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> input) {
                String[] subPackages;
                for (String subPackage : subPackages = basePackage.split(";")) {
                    boolean matched = input.getPackage().getName().startsWith(subPackage.trim());
                    if (!matched) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }
}

